/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public final class VecInt
implements IVecInt {
    private static final long serialVersionUID = 1L;
    public static final IVecInt EMPTY;
    private int nbelem;
    private int[] myarray;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.core.VecInt");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY = new IVecInt(){
            private static final long serialVersionUID = 1L;

            public int size() {
                return 0;
            }

            public void shrink(int nofelems) {
            }

            public void shrinkTo(int newsize) {
            }

            public IVecInt pop() {
                throw new UnsupportedOperationException();
            }

            public void growTo(int newsize, int pad) {
            }

            public void ensure(int nsize) {
            }

            public IVecInt push(int elem) {
                throw new UnsupportedOperationException();
            }

            public void unsafePush(int elem) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
            }

            public int last() {
                throw new UnsupportedOperationException();
            }

            public int get(int i) {
                throw new UnsupportedOperationException();
            }

            public void set(int i, int o) {
                throw new UnsupportedOperationException();
            }

            public boolean contains(int e) {
                return false;
            }

            public void copyTo(IVecInt copy) {
            }

            public void copyTo(int[] is) {
            }

            public void moveTo(IVecInt dest) {
            }

            public void moveTo2(IVecInt dest) {
            }

            public void moveTo(int[] dest) {
            }

            public void insertFirst(int elem) {
                throw new UnsupportedOperationException();
            }

            public void remove(int elem) {
                throw new UnsupportedOperationException();
            }

            public int delete(int i) {
                throw new UnsupportedOperationException();
            }

            public void sort() {
            }

            public void sortUnique() {
            }

            public int unsafeGet(int eleem) {
                throw new UnsupportedOperationException();
            }

            public int containsAt(int e) {
                throw new UnsupportedOperationException();
            }

            public int containsAt(int e, int from2) {
                throw new UnsupportedOperationException();
            }

            public void moveTo(int dest, int source) {
                throw new UnsupportedOperationException();
            }

            public boolean isEmpty() {
                return true;
            }

            public IteratorInt iterator() {
                return new IteratorInt(){

                    public boolean hasNext() {
                        return false;
                    }

                    public int next() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int[] toArray() {
                throw new UnsupportedOperationException();
            }

            public int indexOf(int e) {
                return -1;
            }

            public String toString() {
                return "[]";
            }

            public void moveTo(int sourceStartingIndex, int[] dest) {
                throw new UnsupportedOperationException();
            }

            public IVecInt[] subset(int cardinal) {
                return new IVecInt[0];
            }
        };
    }

    public VecInt() {
        this(5);
    }

    public VecInt(int size2) {
        this.myarray = new int[size2];
    }

    public VecInt(int[] lits) {
        this.myarray = lits;
        this.nbelem = lits.length;
    }

    public VecInt(int size2, int pad) {
        this.myarray = new int[size2];
        int i = 0;
        while (i < size2) {
            this.myarray[i] = pad;
            ++i;
        }
        this.nbelem = size2;
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int nofelems) {
        this.nbelem -= nofelems;
    }

    public void shrinkTo(int newsize) {
        this.nbelem = newsize;
    }

    public IVecInt pop() {
        --this.nbelem;
        return this;
    }

    public void growTo(int newsize, int pad) {
        this.ensure(newsize);
        while (--newsize >= 0) {
            this.myarray[this.nbelem++] = pad;
        }
    }

    public void ensure(int nsize) {
        if (nsize >= this.myarray.length) {
            int[] narray = new int[Math.max(nsize, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, narray, 0, this.nbelem);
            this.myarray = narray;
        }
    }

    public IVecInt push(int elem) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = elem;
        return this;
    }

    public void unsafePush(int elem) {
        this.myarray[this.nbelem++] = elem;
    }

    public void clear() {
        this.nbelem = 0;
    }

    public int last() {
        return this.myarray[this.nbelem - 1];
    }

    public int get(int i) {
        return this.myarray[i];
    }

    public int unsafeGet(int i) {
        return this.myarray[i];
    }

    public void set(int i, int o) {
        if (!($assertionsDisabled || i >= 0 && i < this.nbelem)) {
            throw new AssertionError();
        }
        this.myarray[i] = o;
    }

    public boolean contains(int e) {
        int[] workArray = this.myarray;
        int i = 0;
        while (i < this.nbelem) {
            if (workArray[i] == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(int e) {
        int[] workArray = this.myarray;
        int i = 0;
        while (i < this.nbelem) {
            if (workArray[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int containsAt(int e) {
        return this.containsAt(e, -1);
    }

    public int containsAt(int e, int from2) {
        int[] workArray = this.myarray;
        int i = from2 + 1;
        while (i < this.nbelem) {
            if (workArray[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void copyTo(IVecInt copy) {
        VecInt ncopy = (VecInt)copy;
        int nsize = this.nbelem + ncopy.nbelem;
        ncopy.ensure(nsize);
        System.arraycopy(this.myarray, 0, ncopy.myarray, ncopy.nbelem, this.nbelem);
        ncopy.nbelem = nsize;
    }

    public void copyTo(int[] is) {
        System.arraycopy(this.myarray, 0, is, 0, this.nbelem);
    }

    public void moveTo(IVecInt dest) {
        this.copyTo(dest);
        this.nbelem = 0;
    }

    public void moveTo2(IVecInt dest) {
        VecInt ndest = (VecInt)dest;
        int s2 = ndest.nbelem;
        int[] tmp = ndest.myarray;
        ndest.myarray = this.myarray;
        ndest.nbelem = this.nbelem;
        this.myarray = tmp;
        this.nbelem = s2;
        this.nbelem = 0;
    }

    public void moveTo(int dest, int source) {
        this.myarray[dest] = this.myarray[source];
    }

    public void moveTo(int[] dest) {
        System.arraycopy(this.myarray, 0, dest, 0, this.nbelem);
        this.nbelem = 0;
    }

    public void moveTo(int sourceStartingIndex, int[] dest) {
        System.arraycopy(this.myarray, sourceStartingIndex, dest, 0, this.nbelem - sourceStartingIndex);
        this.nbelem = 0;
    }

    public void insertFirst(int elem) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = elem;
            return;
        }
        this.push(elem);
    }

    public void remove(int elem) {
        int j = 0;
        while (this.myarray[j] != elem) {
            if (!$assertionsDisabled && j >= this.size()) {
                throw new AssertionError();
            }
            ++j;
        }
        System.arraycopy(this.myarray, j + 1, this.myarray, j, this.size() - j - 1);
        this.pop();
    }

    public int delete(int i) {
        int ith = this.myarray[i];
        this.myarray[i] = this.myarray[--this.nbelem];
        return ith;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.nbelem - 1) {
            stb.append(this.myarray[i]);
            stb.append(",");
            ++i;
        }
        if (this.nbelem > 0) {
            stb.append(this.myarray[this.nbelem - 1]);
        }
        return stb.toString();
    }

    void selectionSort(int from2, int to2) {
        int i = from2;
        while (i < to2 - 1) {
            int best_i = i;
            int j = i + 1;
            while (j < to2) {
                if (this.myarray[j] < this.myarray[best_i]) {
                    best_i = j;
                }
                ++j;
            }
            int tmp = this.myarray[i];
            this.myarray[i] = this.myarray[best_i];
            this.myarray[best_i] = tmp;
            ++i;
        }
    }

    void sort(int from2, int to2) {
        int width = to2 - from2;
        if (width <= 15) {
            this.selectionSort(from2, to2);
        } else {
            int[] locarray = this.myarray;
            int pivot = locarray[width / 2 + from2];
            int i = from2 - 1;
            int j = to2;
            while (true) {
                if (locarray[++i] < pivot) {
                    continue;
                }
                while (pivot < locarray[--j]) {
                }
                if (i >= j) break;
                int tmp = locarray[i];
                locarray[i] = locarray[j];
                locarray[j] = tmp;
            }
            this.sort(from2, i);
            this.sort(i, to2);
        }
    }

    public void sort() {
        this.sort(0, this.nbelem);
    }

    public void sortUnique() {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem);
        int i = 1;
        int[] locarray = this.myarray;
        int last2 = locarray[0];
        int j = 1;
        while (j < this.nbelem) {
            if (last2 < locarray[j]) {
                last2 = locarray[i] = locarray[j];
                ++i;
            }
            ++j;
        }
        this.nbelem = i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VecInt) {
            VecInt v = (VecInt)obj;
            if (v.nbelem != this.nbelem) {
                return false;
            }
            int i = 0;
            while (i < this.nbelem) {
                if (v.myarray[i] != this.myarray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long sum2 = 0L;
        int i = 0;
        while (i < this.nbelem) {
            sum2 += (long)this.myarray[i];
            ++i;
        }
        return (int)sum2 / this.nbelem;
    }

    public void pushAll(IVecInt vec) {
        VecInt nvec = (VecInt)vec;
        int nsize = this.nbelem + nvec.nbelem;
        this.ensure(nsize);
        System.arraycopy(nvec.myarray, 0, this.myarray, this.nbelem, nvec.nbelem);
        this.nbelem = nsize;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isSubsetOf(VecInt vec) {
        i = 0;
        j = 0;
        ** GOTO lbl10
        {
            ++j;
            do {
                if (j < vec.nbelem && vec.myarray[j] < this.myarray[i]) continue block0;
                if (j == vec.nbelem || this.myarray[i] != vec.myarray[j]) {
                    return false;
                }
                ++i;
lbl10:
                // 2 sources

            } while (i < this.nbelem && j < vec.nbelem);
        }
        return true;
    }

    public IteratorInt iterator() {
        return new IteratorInt(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < VecInt.this.nbelem;
            }

            public int next() {
                if (this.i == VecInt.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return VecInt.this.myarray[this.i++];
            }
        };
    }

    public boolean isEmpty() {
        return this.nbelem == 0;
    }

    public int[] toArray() {
        return this.myarray;
    }

    public IVecInt[] subset(int cardinal) {
        ArrayList<IVecInt> liste = new ArrayList<IVecInt>();
        if (cardinal == 1) {
            IVecInt[] result2 = new VecInt[this.size()];
            int i = 0;
            while (i < this.size()) {
                result2[i] = new VecInt(new int[]{this.get(i)});
                ++i;
            }
            return result2;
        }
        if (this.size() == 0) {
            IVecInt[] result3 = new VecInt[]{};
            return result3;
        }
        VecInt subVec = new VecInt();
        this.copyTo(subVec);
        subVec.remove(this.get(0));
        IVecInt[] iVecIntArray = subVec.subset(cardinal - 1);
        int n = iVecIntArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVecInt vecWithFirst = iVecIntArray[n2];
            VecInt newVec = new VecInt();
            vecWithFirst.copyTo(newVec);
            newVec.insertFirst(this.get(0));
            liste.add(newVec);
            ++n2;
        }
        iVecIntArray = subVec.subset(cardinal);
        n = iVecIntArray.length;
        n2 = 0;
        while (n2 < n) {
            IVecInt vecWithoutFirst = iVecIntArray[n2];
            liste.add(vecWithoutFirst);
            ++n2;
        }
        IVecInt[] result4 = new VecInt[liste.size()];
        int i = 0;
        while (i < liste.size()) {
            result4[i] = (IVecInt)liste.get(i);
            ++i;
        }
        return result4;
    }
}

