/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.cnf.UnitClauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public final class MaxWatchCard
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int degree;
    private final int[] lits;
    private boolean moreThan;
    private int watchCumul;
    private final ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.card.MaxWatchCard");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private MaxWatchCard(ILits voc, IVecInt ps, boolean moreThan, int degree) {
        this.voc = voc;
        this.degree = degree;
        this.moreThan = moreThan;
        int[] index = new int[voc.nVars() * 2 + 2];
        int i = 0;
        while (i < index.length) {
            index[i] = 0;
            ++i;
        }
        i = 0;
        while (i < ps.size()) {
            if (index[ps.get(i) ^ 1] == 0) {
                int n = ps.get(i);
                index[n] = index[n] + 1;
            } else {
                int n = ps.get(i) ^ 1;
                index[n] = index[n] - 1;
            }
            ++i;
        }
        int ind = 0;
        while (ind < ps.size()) {
            if (index[ps.get(ind)] > 0) {
                int n = ps.get(ind);
                index[n] = index[n] - 1;
                ++ind;
                continue;
            }
            if ((ps.get(ind) & 1) != 0) {
                --this.degree;
            }
            ps.set(ind, ps.last());
            ps.pop();
        }
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
        this.normalize();
        this.watchCumul = 0;
        int i2 = 0;
        while (i2 < this.lits.length) {
            if (!voc.isFalsified(this.lits[i2])) {
                ++this.watchCumul;
                voc.watch(this.lits[i2] ^ 1, this);
            }
            ++i2;
        }
    }

    public void calcReason(int p, IVecInt outReason) {
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isFalsified(this.lits[i])) {
                outReason.push(this.lits[i] ^ 1);
            }
            ++i;
        }
    }

    public double getActivity() {
        return 0.0;
    }

    public void incActivity(double claInc) {
    }

    public boolean learnt() {
        return false;
    }

    public boolean locked() {
        return true;
    }

    public static Constr maxWatchCardNew(UnitPropagationListener s2, ILits voc, IVecInt ps, boolean moreThan, int degree) throws ContradictionException {
        MaxWatchCard outclause = null;
        if (ps.size() < degree) {
            throw new ContradictionException("Creating trivially inconsistent constraint");
        }
        if (ps.size() == degree) {
            int i = 0;
            while (i < ps.size()) {
                if (!s2.enqueue(ps.get(i))) {
                    throw new ContradictionException("Contradiction with implied literal");
                }
                ++i;
            }
            return new UnitClauses(ps);
        }
        outclause = new MaxWatchCard(voc, ps, moreThan, degree);
        if (outclause.degree <= 0) {
            return null;
        }
        if (outclause.watchCumul < outclause.degree) {
            throw new ContradictionException();
        }
        if (outclause.watchCumul == outclause.degree) {
            int i = 0;
            while (i < outclause.lits.length) {
                if (!s2.enqueue(outclause.lits[i])) {
                    throw new ContradictionException("Contradiction with implied literal");
                }
                ++i;
            }
            return null;
        }
        return outclause;
    }

    public final void normalize() {
        if (!this.moreThan) {
            this.degree = 0 - this.degree;
            int indLit = 0;
            while (indLit < this.lits.length) {
                this.lits[indLit] = this.lits[indLit] ^ 1;
                ++this.degree;
                ++indLit;
            }
            this.moreThan = true;
        }
    }

    public boolean propagate(UnitPropagationListener s2, int p) {
        this.voc.watch(p, this);
        if (!$assertionsDisabled && this.voc.isFalsified(p)) {
            throw new AssertionError();
        }
        if (this.watchCumul == this.degree) {
            return false;
        }
        this.voc.undos(p).push(this);
        --this.watchCumul;
        if (this.watchCumul == this.degree) {
            int[] nArray = this.lits;
            int n = this.lits.length;
            int n2 = 0;
            while (n2 < n) {
                int q = nArray[n2];
                if (this.voc.isUnassigned(q) && !s2.enqueue(q, this)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void remove(UnitPropagationListener upl) {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            this.voc.watches(q ^ 1).remove(this);
            ++n2;
        }
    }

    public void rescaleBy(double d) {
    }

    public boolean simplify() {
        int i = 0;
        int curr = this.watchCumul;
        while (i < this.lits.length) {
            if (!this.voc.isUnassigned(this.lits[i++]) || --curr >= this.degree) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        if (this.lits.length > 0) {
            if (this.voc.isUnassigned(this.lits[0])) {
                stb.append(Lits.toString(this.lits[0]));
                stb.append(" ");
            }
            int i = 1;
            while (i < this.lits.length) {
                if (this.voc.isUnassigned(this.lits[i])) {
                    stb.append(" + ");
                    stb.append(Lits.toString(this.lits[i]));
                    stb.append(" ");
                }
                ++i;
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    public void undo(int p) {
        ++this.watchCumul;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int i) {
        return this.lits[i];
    }

    public void assertConstraint(UnitPropagationListener s2) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getCoef(int literal) {
        return BigInteger.ONE;
    }

    public BigInteger getDegree() {
        return BigInteger.valueOf(this.degree);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public void forwardActivity(double claInc) {
    }

    public boolean canBePropagatedMultipleTimes() {
        return true;
    }
}

