/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class BinaryClause
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    private final ILits voc;
    protected int head;
    protected int tail;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.cnf.BinaryClause");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BinaryClause(IVecInt ps, ILits voc) {
        if (!$assertionsDisabled && ps.size() != 2) {
            throw new AssertionError();
        }
        this.head = ps.get(0);
        this.tail = ps.get(1);
        this.voc = voc;
        this.activity = 0.0;
    }

    public void calcReason(int p, IVecInt outReason) {
        if (this.voc.isFalsified(this.head)) {
            outReason.push(LiteralsUtils.neg(this.head));
        }
        if (this.voc.isFalsified(this.tail)) {
            outReason.push(LiteralsUtils.neg(this.tail));
        }
    }

    public void remove(UnitPropagationListener upl) {
        this.voc.watches(LiteralsUtils.neg(this.head)).remove(this);
        this.voc.watches(LiteralsUtils.neg(this.tail)).remove(this);
    }

    public boolean simplify() {
        return this.voc.isSatisfied(this.head) || this.voc.isSatisfied(this.tail);
    }

    public boolean propagate(UnitPropagationListener s2, int p) {
        this.voc.watch(p, this);
        if (this.head == LiteralsUtils.neg(p)) {
            return s2.enqueue(this.tail, this);
        }
        if (!$assertionsDisabled && this.tail != LiteralsUtils.neg(p)) {
            throw new AssertionError();
        }
        return s2.enqueue(this.head, this);
    }

    public boolean locked() {
        return this.voc.getReason(this.head) == this || this.voc.getReason(this.tail) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append(Lits.toString(this.head));
        stb.append("[");
        stb.append(this.voc.valueToString(this.head));
        stb.append("]");
        stb.append(" ");
        stb.append(Lits.toString(this.tail));
        stb.append("[");
        stb.append(this.voc.valueToString(this.tail));
        stb.append("]");
        return stb.toString();
    }

    public int get(int i) {
        if (i == 0) {
            return this.head;
        }
        if (!$assertionsDisabled && i != 1) {
            throw new AssertionError();
        }
        return this.tail;
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return 2;
    }

    public void assertConstraint(UnitPropagationListener s2) {
        if (!$assertionsDisabled && !this.voc.isUnassigned(this.head)) {
            throw new AssertionError();
        }
        boolean ret = s2.enqueue(this.head, this);
        if (!$assertionsDisabled && !ret) {
            throw new AssertionError();
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[]{this.head, this.tail};
        return tmp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            BinaryClause wcl = (BinaryClause)obj;
            return wcl.head == this.head && wcl.tail == this.tail;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long sum2 = this.head + this.tail;
        return (int)sum2 / 2;
    }

    public void register() {
        this.voc.watch(LiteralsUtils.neg(this.head), this);
        this.voc.watch(LiteralsUtils.neg(this.tail), this);
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }
}

