/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class Clauses {
    public static IVecInt sanityCheck(IVecInt ps, ILits voc, UnitPropagationListener s2) throws ContradictionException {
        int i = 0;
        while (i < ps.size()) {
            if (voc.isUnassigned(ps.get(i))) {
                ++i;
                continue;
            }
            if (voc.isSatisfied(ps.get(i))) {
                return null;
            }
            ps.delete(i);
        }
        ps.sortUnique();
        i = 0;
        while (i < ps.size() - 1) {
            if (ps.get(i) == (ps.get(i + 1) ^ 1)) {
                return null;
            }
            ++i;
        }
        Clauses.propagationCheck(ps, s2);
        return ps;
    }

    static boolean propagationCheck(IVecInt ps, UnitPropagationListener s2) throws ContradictionException {
        if (ps.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (ps.size() == 1) {
            if (!s2.enqueue(ps.get(0))) {
                throw new ContradictionException("Contradictory Unit Clauses");
            }
            return true;
        }
        return false;
    }
}

