/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class HTClause
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] middleLits;
    protected final ILits voc;
    protected int head;
    protected int tail;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.cnf.HTClause");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HTClause(IVecInt ps, ILits voc) {
        if (!$assertionsDisabled && ps.size() <= 1) {
            throw new AssertionError();
        }
        this.head = ps.get(0);
        this.tail = ps.last();
        int size2 = ps.size() - 2;
        if (!$assertionsDisabled && size2 <= 0) {
            throw new AssertionError();
        }
        this.middleLits = new int[size2];
        System.arraycopy(ps.toArray(), 1, this.middleLits, 0, size2);
        ps.clear();
        if (!$assertionsDisabled && ps.size() != 0) {
            throw new AssertionError();
        }
        this.voc = voc;
        this.activity = 0.0;
    }

    public void calcReason(int p, IVecInt outReason) {
        if (this.voc.isFalsified(this.head)) {
            outReason.push(LiteralsUtils.neg(this.head));
        }
        int[] mylits = this.middleLits;
        int i = 0;
        while (i < mylits.length) {
            if (this.voc.isFalsified(mylits[i])) {
                outReason.push(LiteralsUtils.neg(mylits[i]));
            }
            ++i;
        }
        if (this.voc.isFalsified(this.tail)) {
            outReason.push(LiteralsUtils.neg(this.tail));
        }
    }

    public void remove(UnitPropagationListener upl) {
        this.voc.watches(LiteralsUtils.neg(this.head)).remove(this);
        this.voc.watches(LiteralsUtils.neg(this.tail)).remove(this);
    }

    public boolean simplify() {
        if (this.voc.isSatisfied(this.head) || this.voc.isSatisfied(this.tail)) {
            return true;
        }
        int i = 0;
        while (i < this.middleLits.length) {
            if (this.voc.isSatisfied(this.middleLits[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener s2, int p) {
        if (this.head == LiteralsUtils.neg(p)) {
            int[] mylits = this.middleLits;
            int temphead = 0;
            while (temphead < mylits.length && this.voc.isFalsified(mylits[temphead])) {
                ++temphead;
            }
            if (!$assertionsDisabled && temphead > mylits.length) {
                throw new AssertionError();
            }
            if (temphead == mylits.length) {
                this.voc.watch(p, this);
                return s2.enqueue(this.tail, this);
            }
            this.head = mylits[temphead];
            mylits[temphead] = LiteralsUtils.neg(p);
            this.voc.watch(LiteralsUtils.neg(this.head), this);
            return true;
        }
        if (!$assertionsDisabled && this.tail != LiteralsUtils.neg(p)) {
            throw new AssertionError();
        }
        int[] mylits = this.middleLits;
        int temptail = mylits.length - 1;
        while (temptail >= 0 && this.voc.isFalsified(mylits[temptail])) {
            --temptail;
        }
        if (!$assertionsDisabled && -1 > temptail) {
            throw new AssertionError();
        }
        if (-1 == temptail) {
            this.voc.watch(p, this);
            return s2.enqueue(this.head, this);
        }
        this.tail = mylits[temptail];
        mylits[temptail] = LiteralsUtils.neg(p);
        this.voc.watch(LiteralsUtils.neg(this.tail), this);
        return true;
    }

    public boolean locked() {
        return this.voc.getReason(this.head) == this || this.voc.getReason(this.tail) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append(Lits.toString(this.head));
        stb.append("[");
        stb.append(this.voc.valueToString(this.head));
        stb.append("]");
        stb.append(" ");
        int i = 0;
        while (i < this.middleLits.length) {
            stb.append(Lits.toString(this.middleLits[i]));
            stb.append("[");
            stb.append(this.voc.valueToString(this.middleLits[i]));
            stb.append("]");
            stb.append(" ");
            ++i;
        }
        stb.append(Lits.toString(this.tail));
        stb.append("[");
        stb.append(this.voc.valueToString(this.tail));
        stb.append("]");
        return stb.toString();
    }

    public int get(int i) {
        if (i == 0) {
            return this.head;
        }
        if (i == this.middleLits.length + 1) {
            return this.tail;
        }
        return this.middleLits[i - 1];
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.middleLits.length + 2;
    }

    public void assertConstraint(UnitPropagationListener s2) {
        if (!$assertionsDisabled && !this.voc.isUnassigned(this.head)) {
            throw new AssertionError();
        }
        boolean ret = s2.enqueue(this.head, this);
        if (!$assertionsDisabled && !ret) {
            throw new AssertionError();
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.middleLits, 0, tmp, 1, this.middleLits.length);
        tmp[0] = this.head;
        tmp[tmp.length - 1] = this.tail;
        return tmp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            HTClause wcl = (HTClause)obj;
            if (wcl.head != this.head || wcl.tail != this.tail) {
                return false;
            }
            if (this.middleLits.length != wcl.middleLits.length) {
                return false;
            }
            int[] nArray = this.middleLits;
            int n = this.middleLits.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                int lit = nArray[n2];
                boolean ok = false;
                int[] nArray2 = wcl.middleLits;
                int n3 = wcl.middleLits.length;
                int n4 = 0;
                while (n4 < n3) {
                    int lit2 = nArray2[n4];
                    if (lit == lit2) {
                        ok = true;
                        break;
                    }
                    ++n4;
                }
                if (!ok) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long sum2 = this.head + this.tail;
        int[] nArray = this.middleLits;
        int n = this.middleLits.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            sum2 += (long)p;
            ++n2;
        }
        return (int)sum2 / this.middleLits.length;
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }
}

