/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ActivityListener;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.ConflictTimerContainer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Counter;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.minisat.core.VoidTracing;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver<D extends DataStructureFactory>
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final IVec<Constr> constrs = new Vec<Constr>();
    private final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected ILits voc;
    private IOrder order;
    private final ActivityComparator comparator = new ActivityComparator();
    private SolverStats stats = new SolverStats();
    private LearningStrategy<D> learner;
    protected volatile boolean undertimeout;
    private long timeout = Integer.MAX_VALUE;
    private boolean timeBasedTimeout = true;
    protected D dsfactory;
    private SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    private SearchListener slistener = new VoidTracing();
    private RestartStrategy restarter;
    private final Map<String, Counter> constrTypes = new HashMap<String, Counter>();
    private boolean isDBSimplificationAllowed = false;
    private final IVecInt learnedLiterals = new VecInt();
    private boolean verbose = false;
    private String prefix = "c ";
    private int declaredMaxVarId = 0;
    private boolean[] mseen = new boolean[0];
    private final IVecInt mpreason = new VecInt();
    private final IVecInt moutLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION;
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        @Override
        public void simplify(IVecInt conflictToReduce) {
            Solver.this.simpleSimplification(conflictToReduce);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        @Override
        public void simplify(IVecInt conflictToReduce) {
            Solver.this.expensiveSimplification(conflictToReduce);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION_WLONLY = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        @Override
        public void simplify(IVecInt conflictToReduce) {
            Solver.this.expensiveSimplificationWLOnly(conflictToReduce);
        }

        public String toString() {
            return "Expensive reason simplification specific for WL data structure";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final IVec<Propagatable> watched = new Vec<Propagatable>();
    private final Pair analysisResult = new Pair();
    private boolean[] userbooleanmodel;
    private IVecInt unsatExplanationInTermsOfAssumptions;
    private final IVecInt implied = new VecInt();
    private final IVecInt decisions = new VecInt();
    private int[] fullmodel;
    private double timebegin = 0.0;
    private boolean needToReduceDB;
    private ConflictTimer conflictCount;
    private transient Timer timer;
    public final LearnedConstraintsDeletionStrategy memory_based = new LearnedConstraintsDeletionStrategy(){
        private static final long serialVersionUID = 1L;
        final long memorybound = Runtime.getRuntime().freeMemory() / 10L;
        private final ConflictTimer freeMem = new ConflictTimerAdapter(500){
            private static final long serialVersionUID = 1L;

            void run() {
                long freemem = Runtime.getRuntime().freeMemory();
                if (freemem < memorybound) {
                    Solver.this.needToReduceDB = true;
                }
            }
        };

        @Override
        public void reduce(IVec<Constr> learnedConstrs) {
            Solver.this.sortOnActivity();
            int j = 0;
            int i = 0;
            while (i < Solver.this.learnts.size() / 2) {
                Constr c = (Constr)Solver.this.learnts.get(i);
                if (c.locked() || c.size() == 2) {
                    Solver.this.learnts.set(j++, (Constr)Solver.this.learnts.get(i));
                } else {
                    c.remove(Solver.this);
                }
                ++i;
            }
            while (i < Solver.this.learnts.size()) {
                Solver.this.learnts.set(j++, (Constr)Solver.this.learnts.get(i));
                ++i;
            }
            if (Solver.this.verbose) {
                System.out.println(new StringBuffer(String.valueOf(Solver.this.getLogPrefix())).append("cleaning ").append(Solver.this.learnts.size() - j).append(" clauses out of ").append(Solver.this.learnts.size()).toString());
                System.out.flush();
            }
            Solver.this.learnts.shrinkTo(j);
        }

        @Override
        public ConflictTimer getTimer() {
            return this.freeMem;
        }

        public String toString() {
            return "Memory based learned constraints deletion strategy";
        }

        @Override
        public void init() {
        }

        @Override
        public void onConflict(Constr constr) {
        }

        @Override
        public void onConflictAnalysis(Constr reason) {
            if (reason.learnt()) {
                Solver.this.claBumpActivity(reason);
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy glucose;
    private LearnedConstraintsDeletionStrategy learnedConstraintsDeletionStrategy = this.glucose = new LearnedConstraintsDeletionStrategy(){
        private static final long serialVersionUID = 1L;
        private int[] flags = new int[0];
        private int flag = 0;
        private int wall = 0;
        private final ConflictTimer clauseManagement = new ConflictTimerAdapter(1000){
            private static final long serialVersionUID = 1L;
            private int nbconflict;
            private static final int MAX_CLAUSE = 5000;
            private static final int INC_CLAUSE = 1000;
            private int nextbound;
            {
                this.nbconflict = 0;
                this.nextbound = 5000;
            }

            void run() {
                this.nbconflict += this.bound();
                if (this.nbconflict >= this.nextbound) {
                    this.nextbound += 1000;
                    if (this.nextbound > wall) {
                        this.nextbound = wall;
                    }
                    this.nbconflict = 0;
                    Solver.this.needToReduceDB = true;
                }
            }

            public void reset() {
                super.reset();
                this.nextbound = 5000;
                if (this.nbconflict >= this.nextbound) {
                    this.nbconflict = 0;
                    Solver.this.needToReduceDB = true;
                }
            }
        };

        @Override
        public void reduce(IVec<Constr> learnedConstrs) {
            int j;
            Solver.this.sortOnActivity();
            int i = j = learnedConstrs.size() / 2;
            while (i < learnedConstrs.size()) {
                Constr c = learnedConstrs.get(i);
                if (c.locked() || c.getActivity() <= 2.0) {
                    learnedConstrs.set(j++, (Constr)Solver.this.learnts.get(i));
                } else {
                    c.remove(Solver.this);
                }
                ++i;
            }
            if (Solver.this.verbose) {
                System.out.println(new StringBuffer(String.valueOf(Solver.this.getLogPrefix())).append("cleaning ").append(learnedConstrs.size() - j).append(" clauses out of ").append(learnedConstrs.size()).append(" with flag ").append(this.flag).append("/").append(((Solver)Solver.this).stats.conflicts).toString());
                System.out.flush();
            }
            Solver.this.learnts.shrinkTo(j);
        }

        @Override
        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Glucose learned constraints deletion strategy";
        }

        @Override
        public void init() {
            int howmany = Solver.this.voc.nVars();
            int n = this.wall = Solver.this.constrs.size() > 10000 ? Solver.this.constrs.size() : 10000;
            if (this.flags.length <= howmany) {
                this.flags = new int[howmany + 1];
            }
            this.flag = 0;
            this.clauseManagement.reset();
        }

        @Override
        public void onConflict(Constr constr) {
            int nblevel = 1;
            ++this.flag;
            int i = 1;
            while (i < constr.size()) {
                int currentLevel = Solver.this.voc.getLevel(constr.get(i));
                if (this.flags[currentLevel] != this.flag) {
                    this.flags[currentLevel] = this.flag;
                    ++nblevel;
                }
                ++i;
            }
            constr.incActivity(nblevel);
        }

        @Override
        public void onConflictAnalysis(Constr reason) {
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.core.Solver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_SIMPLIFICATION = new ISimplifier(){
            private static final long serialVersionUID = 1L;

            @Override
            public void simplify(IVecInt outLearnt) {
            }

            public String toString() {
                return "No reason simplification";
            }
        };
    }

    protected IVecInt dimacs2internal(IVecInt in) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(in.size());
        int i = 0;
        while (i < in.size()) {
            int p = in.get(i);
            if (p == 0) {
                throw new IllegalArgumentException("0 is not a valid variable identifier");
            }
            this.__dimacs_out.unsafePush(this.voc.getFromPool(p));
            ++i;
        }
        return this.__dimacs_out;
    }

    @Override
    public void registerLiteral(int p) {
        this.voc.getFromPool(p);
    }

    public Solver(LearningStrategy<D> learner, D dsf, IOrder order, RestartStrategy restarter) {
        this(learner, dsf, new SearchParams(), order, restarter);
    }

    public Solver(LearningStrategy<D> learner, D dsf, SearchParams params, IOrder order, RestartStrategy restarter) {
        this.learner = learner;
        this.order = order;
        this.params = params;
        this.setDataStructureFactory(dsf);
        this.restarter = restarter;
    }

    public final void setDataStructureFactory(D dsf) {
        this.dsfactory = dsf;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = dsf.getVocabulary();
        this.order.setLits(this.voc);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    @Override
    public void setSearchListener(SearchListener sl) {
        this.slistener = sl;
    }

    @Override
    public SearchListener getSearchListener() {
        return this.slistener;
    }

    public void setLearner(LearningStrategy<D> learner) {
        this.learner = learner;
    }

    @Override
    public void setTimeout(int t) {
        this.timeout = (long)t * 1000L;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutMs(long t) {
        this.timeout = t;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutOnConflicts(int count2) {
        this.timeout = count2;
        this.timeBasedTimeout = false;
    }

    public void setSearchParams(SearchParams sp2) {
        this.params = sp2;
    }

    public void setRestartStrategy(RestartStrategy restarter) {
        this.restarter = restarter;
    }

    @Override
    public void expireTimeout() {
        this.undertimeout = false;
        if (this.timeBasedTimeout) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else if (this.conflictCount != null) {
            this.conflictCount = null;
        }
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr c) {
        this.learnts.push(c);
        c.setLearnt();
        c.register();
        ++this.stats.learnedclauses;
        switch (c.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
            }
        }
    }

    public final int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    public int newVar() {
        int index = this.voc.nVars() + 1;
        this.voc.ensurePool(index);
        return index;
    }

    @Override
    public int newVar(int howmany) {
        this.voc.ensurePool(howmany);
        this.declaredMaxVarId = howmany;
        return howmany;
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createClause(vlits));
    }

    @Override
    public boolean removeConstr(IConstr co) {
        if (co == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        Constr c = (Constr)co;
        c.remove(this);
        this.constrs.remove(c);
        this.clearLearntClauses();
        String type = c.getClass().getName();
        this.constrTypes.get(type).dec();
        return true;
    }

    @Override
    public boolean removeSubsumedConstr(IConstr co) {
        if (co == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        if (this.constrs.last() != co) {
            throw new IllegalArgumentException("Can only remove latest added constraint!!!");
        }
        Constr c = (Constr)co;
        c.remove(this);
        this.constrs.pop();
        String type = c.getClass().getName();
        this.constrTypes.get(type).dec();
        return true;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        Iterator<IVecInt> iterator2 = clauses.iterator();
        while (iterator2.hasNext()) {
            this.addClause(iterator2.next());
        }
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        int n = literals.size();
        VecInt opliterals = new VecInt(n);
        IteratorInt iterator2 = literals.iterator();
        while (iterator2.hasNext()) {
            opliterals.push(-iterator2.next());
        }
        return this.addAtLeast(opliterals, n - degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(vlits, degree));
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addAtMost(literals, n));
        group.add(this.addAtLeast(literals, n));
        return group;
    }

    public boolean simplifyDB() {
        IVec[] cs = new IVec[]{this.constrs, this.learnts};
        int type = 0;
        while (type < 2) {
            int j = 0;
            int i = 0;
            while (i < cs[type].size()) {
                if (((Constr)cs[type].get(i)).simplify()) {
                    ((Constr)cs[type].get(i)).remove(this);
                } else {
                    cs[type].moveTo(j++, i);
                }
                ++i;
            }
            cs[type].shrinkTo(j);
            ++type;
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nmodel = new int[this.model.length];
        System.arraycopy(this.model, 0, nmodel, 0, this.model.length);
        return nmodel;
    }

    @Override
    public boolean enqueue(int p) {
        return this.enqueue(p, null);
    }

    @Override
    public boolean enqueue(int p, Constr from2) {
        if (!$assertionsDisabled && p <= 1) {
            throw new AssertionError();
        }
        if (this.voc.isSatisfied(p)) {
            return true;
        }
        if (this.voc.isFalsified(p)) {
            return false;
        }
        this.voc.satisfies(p);
        this.voc.setLevel(p, this.decisionLevel());
        this.voc.setReason(p, from2);
        this.trail.push(p);
        return true;
    }

    public void analyze(Constr confl, Pair results) throws TimeoutException {
        if (!$assertionsDisabled && confl == null) {
            throw new AssertionError();
        }
        boolean[] seen = this.mseen;
        IVecInt outLearnt = this.moutLearnt;
        IVecInt preason = this.mpreason;
        outLearnt.clear();
        if (!$assertionsDisabled && outLearnt.size() != 0) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < seen.length) {
            seen[i] = false;
            ++i;
        }
        int counter = 0;
        int p = -1;
        outLearnt.push(-1);
        int outBtlevel = 0;
        Constr prevConfl = null;
        do {
            preason.clear();
            if (!$assertionsDisabled && confl == null) {
                throw new AssertionError();
            }
            if (prevConfl != confl) {
                confl.calcReason(p, preason);
                this.learnedConstraintsDeletionStrategy.onConflictAnalysis(confl);
                int j = 0;
                while (j < preason.size()) {
                    int q = preason.get(j);
                    this.order.updateVar(q);
                    if (!seen[q >> 1]) {
                        seen[q >> 1] = true;
                        if (this.voc.getLevel(q) == this.decisionLevel()) {
                            ++counter;
                            this.order.updateVarAtDecisionLevel(q);
                        } else if (this.voc.getLevel(q) > 0) {
                            outLearnt.push(q ^ 1);
                            outBtlevel = Math.max(outBtlevel, this.voc.getLevel(q));
                        }
                    }
                    ++j;
                }
            }
            prevConfl = confl;
            do {
                p = this.trail.last();
                confl = this.voc.getReason(p);
                this.undoOne();
            } while (!seen[p >> 1]);
        } while (--counter > 0);
        outLearnt.set(0, p ^ 1);
        this.simplifier.simplify(outLearnt);
        Constr c = this.dsfactory.createUnregisteredClause(outLearnt);
        this.slistener.learn(c);
        this.learnedConstraintsDeletionStrategy.onConflict(c);
        results.reason = c;
        if (!$assertionsDisabled && outBtlevel <= -1) {
            throw new AssertionError();
        }
        results.backtrackLevel = outBtlevel;
    }

    /*
     * Unable to fully structure code
     */
    public IVecInt analyzeFinalConflictInTermsOfAssumptions(Constr confl, IVecInt assumps, int conflictingLiteral) {
        if (assumps.size() != 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            this.trailLim.pop();
lbl5:
            // 2 sources

            ** while (!this.trailLim.isEmpty() && this.trailLim.last() == this.trail.size())
        }
lbl6:
        // 1 sources

        seen = this.mseen;
        outLearnt = this.moutLearnt;
        preason = this.mpreason;
        outLearnt.clear();
        if (this.trailLim.size() == 0) {
            return outLearnt;
        }
        if (!Solver.$assertionsDisabled && outLearnt.size() != 0) {
            throw new AssertionError();
        }
        i = 0;
        while (i < seen.length) {
            seen[i] = false;
            ++i;
        }
        if (confl == null) {
            seen[conflictingLiteral >> 1] = true;
        }
        p = -1;
        while (confl == null && this.trail.size() > 0 && this.trailLim.size() > 0) {
            p = this.trail.last();
            confl = this.voc.getReason(p);
            this.undoOne();
            if (confl == null && p == (conflictingLiteral ^ 1)) {
                outLearnt.push(LiteralsUtils.toDimacs(p));
            }
            if (this.trail.size() > this.trailLim.last()) continue;
            this.trailLim.pop();
        }
        if (confl == null) {
            return outLearnt;
        }
        do {
            preason.clear();
            confl.calcReason(p, preason);
            j = 0;
            while (j < preason.size()) {
                q = preason.get(j);
                if (!seen[q >> 1]) {
                    seen[q >> 1] = true;
                    if (this.voc.getReason(q) == null && this.voc.getLevel(q) > 0) {
                        if (!Solver.$assertionsDisabled && !assumps.contains(LiteralsUtils.toDimacs(q))) {
                            throw new AssertionError();
                        }
                        outLearnt.push(LiteralsUtils.toDimacs(q));
                    }
                }
                ++j;
            }
            do {
                p = this.trail.last();
                confl = this.voc.getReason(p);
                this.undoOne();
                if (this.decisionLevel() <= 0 || this.trail.size() > this.trailLim.last()) continue;
                this.trailLim.pop();
            } while (this.trail.size() > 0 && this.decisionLevel() > 0 && (!seen[p >> 1] || confl == null));
        } while (this.decisionLevel() > 0);
        return outLearnt;
    }

    public void setSimplifier(String simp) {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.sat4j.minisat.core.Solver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Field f = clazz.getDeclaredField(simp);
            this.simplifier = (ISimplifier)f.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.simplifier = NO_SIMPLIFICATION;
        }
    }

    public void setSimplifier(ISimplifier simp) {
        this.simplifier = simp;
    }

    private void simpleSimplification(IVecInt conflictToReduce) {
        boolean[] seen = this.mseen;
        int j = 1;
        int i = 1;
        while (i < conflictToReduce.size()) {
            Constr r = this.voc.getReason(conflictToReduce.get(i));
            if (r == null || r.canBePropagatedMultipleTimes()) {
                conflictToReduce.moveTo(j++, i);
            } else {
                int k = 0;
                while (k < r.size()) {
                    int p = r.get(k);
                    if (!seen[p >> 1] && this.voc.isFalsified(p) && this.voc.getLevel(p) != 0) {
                        conflictToReduce.moveTo(j++, i);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        conflictToReduce.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private void expensiveSimplification(IVecInt conflictToReduce) {
        this.analyzetoclear.clear();
        conflictToReduce.copyTo(this.analyzetoclear);
        int i = 1;
        int j = 1;
        while (i < conflictToReduce.size()) {
            if (this.voc.getReason(conflictToReduce.get(i)) == null || !this.analyzeRemovable(conflictToReduce.get(i))) {
                conflictToReduce.moveTo(j++, i);
            }
            ++i;
        }
        conflictToReduce.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private boolean analyzeRemovable(int p) {
        if (!$assertionsDisabled && this.voc.getReason(p) == null) {
            throw new AssertionError();
        }
        ILits lvoc = this.voc;
        IVecInt lanalyzestack = this.analyzestack;
        IVecInt lanalyzetoclear = this.analyzetoclear;
        lanalyzestack.clear();
        lanalyzestack.push(p);
        boolean[] seen = this.mseen;
        int top = lanalyzetoclear.size();
        while (lanalyzestack.size() > 0) {
            int q = lanalyzestack.last();
            if (!$assertionsDisabled && lvoc.getReason(q) == null) {
                throw new AssertionError();
            }
            Constr c = lvoc.getReason(q);
            lanalyzestack.pop();
            if (c.canBePropagatedMultipleTimes()) {
                int j = top;
                while (j < lanalyzetoclear.size()) {
                    seen[lanalyzetoclear.get((int)j) >> 1] = false;
                    ++j;
                }
                lanalyzetoclear.shrink(lanalyzetoclear.size() - top);
                return false;
            }
            int i = 0;
            while (i < c.size()) {
                int l = c.get(i);
                if (!seen[LiteralsUtils.var(l)] && lvoc.isFalsified(l) && lvoc.getLevel(l) != 0) {
                    if (lvoc.getReason(l) == null) {
                        int j = top;
                        while (j < lanalyzetoclear.size()) {
                            seen[lanalyzetoclear.get((int)j) >> 1] = false;
                            ++j;
                        }
                        lanalyzetoclear.shrink(lanalyzetoclear.size() - top);
                        return false;
                    }
                    seen[l >> 1] = true;
                    lanalyzestack.push(l);
                    lanalyzetoclear.push(l);
                }
                ++i;
            }
        }
        return true;
    }

    private void expensiveSimplificationWLOnly(IVecInt conflictToReduce) {
        this.analyzetoclear.clear();
        conflictToReduce.copyTo(this.analyzetoclear);
        int i = 1;
        int j = 1;
        while (i < conflictToReduce.size()) {
            if (this.voc.getReason(conflictToReduce.get(i)) == null || !this.analyzeRemovableWLOnly(conflictToReduce.get(i))) {
                conflictToReduce.moveTo(j++, i);
            }
            ++i;
        }
        conflictToReduce.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private boolean analyzeRemovableWLOnly(int p) {
        if (!$assertionsDisabled && this.voc.getReason(p) == null) {
            throw new AssertionError();
        }
        this.analyzestack.clear();
        this.analyzestack.push(p);
        boolean[] seen = this.mseen;
        int top = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int q = this.analyzestack.last();
            if (!$assertionsDisabled && this.voc.getReason(q) == null) {
                throw new AssertionError();
            }
            Constr c = this.voc.getReason(q);
            this.analyzestack.pop();
            int i = 1;
            while (i < c.size()) {
                int l = c.get(i);
                if (!seen[LiteralsUtils.var(l)] && this.voc.getLevel(l) != 0) {
                    if (this.voc.getReason(l) == null) {
                        int j = top;
                        while (j < this.analyzetoclear.size()) {
                            seen[this.analyzetoclear.get((int)j) >> 1] = false;
                            ++j;
                        }
                        this.analyzetoclear.shrink(this.analyzetoclear.size() - top);
                        return false;
                    }
                    seen[l >> 1] = true;
                    this.analyzestack.push(l);
                    this.analyzetoclear.push(l);
                }
                ++i;
            }
        }
        return true;
    }

    protected void undoOne() {
        int p = this.trail.last();
        if (!$assertionsDisabled && p <= 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.voc.getLevel(p) < 0) {
            throw new AssertionError();
        }
        int x = p >> 1;
        this.voc.unassign(p);
        this.voc.setReason(p, null);
        this.voc.setLevel(p, -1);
        this.order.undo(x);
        this.trail.pop();
        IVec<Undoable> undos = this.voc.undos(p);
        if (!$assertionsDisabled && undos == null) {
            throw new AssertionError();
        }
        int size2 = undos.size();
        while (size2 > 0) {
            undos.last().undo(p);
            undos.pop();
            --size2;
        }
    }

    @Override
    public void claBumpActivity(Constr confl) {
        confl.incActivity(this.claInc);
        if (confl.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int p) {
        this.order.updateVar(p);
    }

    private void claRescalActivity() {
        int i = 0;
        while (i < this.learnts.size()) {
            this.learnts.get(i).rescaleBy(1.0E-20);
            ++i;
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        IVec<Propagatable> lwatched = this.watched;
        IVecInt ltrail = this.trail;
        ILits lvoc = this.voc;
        SolverStats lstats = this.stats;
        IOrder lorder = this.order;
        SearchListener lslistener = this.slistener;
        while (this.qhead < ltrail.size()) {
            ++lstats.propagations;
            int p = ltrail.get(this.qhead++);
            lslistener.propagating(LiteralsUtils.toDimacs(p), null);
            lorder.assignLiteral(p);
            if (!$assertionsDisabled && p <= 1) {
                throw new AssertionError();
            }
            lwatched.clear();
            lvoc.watches(p).moveTo(lwatched);
            int size2 = lwatched.size();
            int i = 0;
            while (i < size2) {
                ++lstats.inspects;
                if (!lwatched.get(i).propagate(this, p)) {
                    int sizew = lwatched.size();
                    int j = i + 1;
                    while (j < sizew) {
                        lvoc.watch(p, lwatched.get(j));
                        ++j;
                    }
                    this.qhead = ltrail.size();
                    return (Constr)lwatched.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        this.slistener.adding(LiteralsUtils.toDimacs(constr.get(0)));
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int p) {
        if (!$assertionsDisabled && this.trail.size() != this.qhead) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.trailLim.contains(this.trail.size())) {
            throw new AssertionError();
        }
        this.trailLim.push(this.trail.size());
        return this.enqueue(p);
    }

    private void cancel() {
        int decisionvar = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(LiteralsUtils.toDimacs(decisionvar));
        int c = this.trail.size() - this.trailLim.last();
        while (c > 0) {
            this.undoOne();
            --c;
        }
        this.trailLim.pop();
    }

    private void cancelLearntLiterals(int learnedLiteralsLimit) {
        this.learnedLiterals.clear();
        while (this.trail.size() > learnedLiteralsLimit) {
            this.learnedLiterals.push(this.trail.last());
            this.undoOne();
        }
    }

    protected void cancelUntil(int level) {
        while (this.decisionLevel() > level) {
            this.cancel();
        }
        this.qhead = this.trail.size();
    }

    Lbool search(long nofConflicts, IVecInt assumps) {
        if (!$assertionsDisabled && this.rootLevel != this.decisionLevel()) {
            throw new AssertionError();
        }
        ++this.stats.starts;
        int conflictC = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            this.slistener.beginLoop();
            Constr confl = this.propagate();
            if (!$assertionsDisabled && this.trail.size() != this.qhead) {
                throw new AssertionError();
            }
            if (confl == null) {
                if (this.decisionLevel() == 0 && this.isDBSimplificationAllowed) {
                    ++this.stats.rootSimplifications;
                    boolean ret = this.simplifyDB();
                    if (!$assertionsDisabled && !ret) {
                        throw new AssertionError();
                    }
                }
                if (!$assertionsDisabled && this.nAssigns() > this.voc.realnVars()) {
                    throw new AssertionError();
                }
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.slistener.solutionFound();
                    this.modelFound();
                    return Lbool.TRUE;
                }
                if ((long)conflictC >= nofConflicts) {
                    this.cancelUntil(this.rootLevel);
                    return Lbool.UNDEFINED;
                }
                if (this.needToReduceDB) {
                    this.reduceDB();
                    this.needToReduceDB = false;
                }
                ++this.stats.decisions;
                int p = this.order.select();
                if (!$assertionsDisabled && p <= 1) {
                    throw new AssertionError();
                }
                this.slistener.assuming(LiteralsUtils.toDimacs(p));
                boolean ret = this.assume(p);
                if (!$assertionsDisabled && !ret) {
                    throw new AssertionError();
                }
                continue;
            }
            ++this.stats.conflicts;
            ++conflictC;
            this.slistener.conflictFound(confl, this.decisionLevel(), this.trail.size());
            this.conflictCount.newConflict();
            if (this.decisionLevel() == this.rootLevel) {
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(confl, assumps, -1);
                return Lbool.FALSE;
            }
            try {
                this.analyze(confl, this.analysisResult);
            }
            catch (TimeoutException timeoutException) {
                return Lbool.UNDEFINED;
            }
            if (!$assertionsDisabled && this.analysisResult.backtrackLevel >= this.decisionLevel()) {
                throw new AssertionError();
            }
            int backjumpLevel = Math.max(this.analysisResult.backtrackLevel, this.rootLevel);
            this.slistener.backjump(backjumpLevel);
            this.cancelUntil(backjumpLevel);
            if (backjumpLevel == this.rootLevel) {
                conflictC = 0;
            }
            if (!($assertionsDisabled || this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= this.analysisResult.backtrackLevel)) {
                throw new AssertionError();
            }
            if (this.analysisResult.reason == null) {
                return Lbool.FALSE;
            }
            this.record(this.analysisResult.reason);
            this.analysisResult.reason = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    protected void analyzeAtRootLevel(Constr conflict) {
    }

    void modelFound() {
        int p;
        VecInt tempmodel = new VecInt(this.nVars());
        this.userbooleanmodel = new boolean[this.realNumberOfVariables()];
        this.fullmodel = null;
        int i = 1;
        while (i <= this.nVars()) {
            if (this.voc.belongsToPool(i) && !this.voc.isUnassigned(p = this.voc.getFromPool(i))) {
                tempmodel.push(this.voc.isSatisfied(p) ? i : -i);
                this.userbooleanmodel[i - 1] = this.voc.isSatisfied(p);
                if (this.voc.getReason(p) == null) {
                    this.decisions.push(tempmodel.last());
                } else {
                    this.implied.push(tempmodel.last());
                }
            }
            ++i;
        }
        this.model = new int[tempmodel.size()];
        tempmodel.copyTo(this.model);
        if (this.realNumberOfVariables() > this.nVars()) {
            i = this.nVars() + 1;
            while (i <= this.realNumberOfVariables()) {
                if (this.voc.belongsToPool(i) && !this.voc.isUnassigned(p = this.voc.getFromPool(i))) {
                    tempmodel.push(this.voc.isSatisfied(p) ? i : -i);
                    this.userbooleanmodel[i - 1] = this.voc.isSatisfied(p);
                }
                ++i;
            }
            this.fullmodel = new int[tempmodel.size()];
            tempmodel.moveTo(this.fullmodel);
        }
        this.cancelUntil(this.rootLevel);
    }

    @Override
    public int[] primeImplicant() {
        VecInt currentD = new VecInt(this.decisions.size());
        this.decisions.copyTo(currentD);
        VecInt assumptions = new VecInt(this.implied.size() + this.decisions.size());
        this.implied.copyTo(assumptions);
        this.decisions.copyTo(assumptions);
        VecInt prime = new VecInt(assumptions.size());
        this.implied.copyTo(prime);
        int i = 0;
        while (i < currentD.size()) {
            int p = currentD.get(i);
            assumptions.remove(p);
            assumptions.push(-p);
            try {
                if (this.isSatisfiable(assumptions)) {
                    assumptions.pop();
                    assumptions.push(-p);
                } else {
                    prime.push(p);
                    assumptions.pop();
                    assumptions.push(p);
                }
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("Should not timeout here", e);
            }
            ++i;
        }
        int[] implicant = new int[prime.size()];
        prime.copyTo(implicant);
        return implicant;
    }

    @Override
    public boolean model(int var) {
        if (var <= 0 || var > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.userbooleanmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.userbooleanmodel[var - 1];
    }

    @Override
    public void clearLearntClauses() {
        Iterator<Constr> iterator2 = this.learnts.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().remove(this);
        }
        this.learnts.clear();
        this.learnedLiterals.clear();
    }

    protected void reduceDB() {
        ++this.stats.reduceddb;
        this.learnedConstraintsDeletionStrategy.reduce(this.learnts);
        System.gc();
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, false);
    }

    public final LearnedConstraintsDeletionStrategy fixedSize(final int maxsize) {
        return new LearnedConstraintsDeletionStrategy(){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer aTimer;
            {
                this.aTimer = new ConflictTimerAdapter(n){
                    private static final long serialVersionUID = 1L;

                    void run() {
                        Solver.this.needToReduceDB = true;
                    }
                };
            }

            @Override
            public void reduce(IVec<Constr> learnedConstrs) {
                int k = 0;
                int j = 0;
                int i = 0;
                while (i < Solver.this.learnts.size() && Solver.this.learnts.size() - k > maxsize) {
                    Constr c = (Constr)Solver.this.learnts.get(i);
                    if (c.locked() || c.size() == 2) {
                        Solver.this.learnts.set(j++, (Constr)Solver.this.learnts.get(i));
                    } else {
                        c.remove(Solver.this);
                        ++k;
                    }
                    ++i;
                }
                while (i < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(j++, (Constr)Solver.this.learnts.get(i));
                    ++i;
                }
                if (Solver.this.verbose) {
                    System.out.println(new StringBuffer(String.valueOf(Solver.this.getLogPrefix())).append("cleaning ").append(Solver.this.learnts.size() - j).append(" clauses out of ").append(Solver.this.learnts.size()).toString());
                    System.out.flush();
                }
                Solver.this.learnts.shrinkTo(j);
            }

            @Override
            public void onConflictAnalysis(Constr reason) {
            }

            @Override
            public void onConflict(Constr outLearnt) {
            }

            public String toString() {
                return new StringBuffer("Fixed size (").append(maxsize).append(") learned constraints deletion strategy").toString();
            }

            @Override
            public void init() {
            }

            @Override
            public ConflictTimer getTimer() {
                return this.aTimer;
            }
        };
    }

    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsDeletionStrategy lcds) {
        this.learnedConstraintsDeletionStrategy = lcds;
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        Lbool status = Lbool.UNDEFINED;
        int howmany = this.voc.nVars();
        if (this.mseen.length <= howmany) {
            this.mseen = new boolean[howmany + 1];
        }
        this.trail.ensure(howmany);
        this.trailLim.ensure(howmany);
        this.learnedLiterals.ensure(howmany);
        this.decisions.clear();
        this.implied.clear();
        this.slistener.start();
        this.model = null;
        this.userbooleanmodel = null;
        this.unsatExplanationInTermsOfAssumptions = null;
        this.order.init();
        this.learnedConstraintsDeletionStrategy.init();
        int learnedLiteralsLimit = this.trail.size();
        this.qhead = 0;
        int i = learnedLiteralsLimit - 1;
        while (i >= 0) {
            int p = this.trail.get(i);
            IVec<Undoable> undos = this.voc.undos(p);
            if (!$assertionsDisabled && undos == null) {
                throw new AssertionError();
            }
            int size2 = undos.size();
            while (size2 > 0) {
                undos.last().undo(p);
                undos.pop();
                --size2;
            }
            --i;
        }
        IteratorInt iterator2 = this.learnedLiterals.iterator();
        while (iterator2.hasNext()) {
            this.enqueue(iterator2.next());
        }
        Constr confl = this.propagate();
        if (confl != null) {
            this.analyzeAtRootLevel(confl);
            this.slistener.conflictFound(confl, 0, 0);
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(learnedLiteralsLimit);
            return false;
        }
        IteratorInt iterator3 = assumps.iterator();
        while (iterator3.hasNext()) {
            int assump = iterator3.next();
            int p = this.voc.getFromPool(assump);
            if ((this.voc.isSatisfied(p) || this.assume(p)) && (confl = this.propagate()) == null) continue;
            if (confl == null) {
                this.slistener.conflictFound(p);
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(null, assumps, p);
                this.unsatExplanationInTermsOfAssumptions.push(assump);
            } else {
                this.slistener.conflictFound(confl, this.decisionLevel(), this.trail.size());
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(confl, assumps, -1);
            }
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(learnedLiteralsLimit);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        this.order.init();
        this.learner.init();
        boolean firstTimeGlobal = false;
        if (this.timeBasedTimeout) {
            if (!global || this.timer == null) {
                firstTimeGlobal = true;
                this.undertimeout = true;
                TimerTask stopMe = new TimerTask(){

                    public void run() {
                        Solver.this.undertimeout = false;
                    }
                };
                this.timer = new Timer(true);
                this.timer.schedule(stopMe, this.timeout);
                this.conflictCount = this.learnedConstraintsDeletionStrategy.getTimer();
            }
        } else if (!global || this.conflictCount == null) {
            firstTimeGlobal = true;
            this.undertimeout = true;
            ConflictTimerAdapter conflictTimeout = new ConflictTimerAdapter((int)this.timeout){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Solver.this.undertimeout = false;
                }
            };
            this.conflictCount = new ConflictTimerContainer().add(conflictTimeout).add(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        if (!global || firstTimeGlobal) {
            this.restarter.init(this.params);
            this.timebegin = System.currentTimeMillis();
        }
        this.needToReduceDB = false;
        while (status == Lbool.UNDEFINED && this.undertimeout) {
            status = this.search(this.restarter.nextRestartNumberOfConflict(), assumps);
            if (status != Lbool.UNDEFINED) continue;
            this.restarter.onRestart();
            this.slistener.restarting();
        }
        this.cancelUntil(0);
        this.cancelLearntLiterals(learnedLiteralsLimit);
        if (!global && this.timeBasedTimeout) {
            this.timer.cancel();
            this.timer = null;
        }
        this.slistener.end(status);
        if (!this.undertimeout) {
            String message = new StringBuffer(" Timeout (").append(this.timeout).append(this.timeBasedTimeout ? "s" : " conflicts").append(") exceeded").toString();
            throw new TimeoutException(message);
        }
        return status == Lbool.TRUE;
    }

    @Override
    public void printInfos(PrintWriter out, String prefix) {
        out.print(prefix);
        out.println("constraints type ");
        long total = 0L;
        for (Map.Entry<String, Counter> entry : this.constrTypes.entrySet()) {
            out.println(new StringBuffer(String.valueOf(prefix)).append(entry.getKey()).append(" => ").append(entry.getValue()).toString());
            total += (long)entry.getValue().getValue();
        }
        out.print(prefix);
        out.print(total);
        out.println(" constraints processed.");
    }

    public void printLearntClausesInfos(PrintWriter out, String prefix) {
        HashMap<String, Counter> learntTypes = new HashMap<String, Counter>();
        Iterator<Constr> it = this.learnts.iterator();
        while (it.hasNext()) {
            String type = it.next().getClass().getName();
            Counter count2 = (Counter)learntTypes.get(type);
            if (count2 == null) {
                learntTypes.put(type, new Counter());
                continue;
            }
            count2.inc();
        }
        out.print(prefix);
        out.println("learnt constraints type ");
        for (Map.Entry entry : learntTypes.entrySet()) {
            out.println(new StringBuffer(String.valueOf(prefix)).append((String)entry.getKey()).append(" => ").append(entry.getValue()).toString());
        }
    }

    public SolverStats getStats() {
        return this.stats;
    }

    protected void initStats(SolverStats myStats) {
        this.stats = myStats;
    }

    public IOrder getOrder() {
        return this.order;
    }

    public void setOrder(IOrder h) {
        this.order = h;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        this.trail.clear();
        this.trailLim.clear();
        this.qhead = 0;
        Iterator<Constr> iterator2 = this.constrs.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().remove(this);
        }
        this.constrs.clear();
        this.clearLearntClauses();
        this.voc.resetPool();
        this.dsfactory.reset();
        this.stats.reset();
        this.constrTypes.clear();
    }

    @Override
    public int nVars() {
        if (this.declaredMaxVarId == 0) {
            return this.voc.nVars();
        }
        return this.declaredMaxVarId;
    }

    protected IConstr addConstr(Constr constr) {
        if (constr == null) {
            Counter count2 = this.constrTypes.get("ignored satisfied constraints");
            if (count2 == null) {
                this.constrTypes.put("ignored satisfied constraints", new Counter());
            } else {
                count2.inc();
            }
        } else {
            this.constrs.push(constr);
            String type = constr.getClass().getName();
            Counter count3 = this.constrTypes.get(type);
            if (count3 == null) {
                this.constrTypes.put(type, new Counter());
            } else {
                count3.inc();
            }
        }
        return constr;
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.moutLearnt;
    }

    public IConstr getIthConstr(int i) {
        return this.constrs.get(i);
    }

    @Override
    public void printStat(PrintStream out, String prefix) {
        this.printStat(new PrintWriter(out, true), prefix);
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
        this.stats.printStat(out, prefix);
        double cputime = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        out.println(new StringBuffer(String.valueOf(prefix)).append("speed (assignments/second)\t: ").append((double)this.stats.propagations / cputime).toString());
        this.order.printStat(out, prefix);
        this.printLearntClausesInfos(out, prefix);
    }

    @Override
    public String toString(String prefix) {
        StringBuffer stb = new StringBuffer();
        Object[] objs = new Object[]{this.dsfactory, this.learner, this.params, this.order, this.simplifier, this.restarter, this.learnedConstraintsDeletionStrategy};
        stb.append(prefix);
        stb.append("--- Begin Solver configuration ---");
        stb.append("\n");
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            stb.append(prefix);
            stb.append(o.toString());
            stb.append("\n");
            ++n2;
        }
        stb.append(prefix);
        stb.append("timeout=");
        if (this.timeBasedTimeout) {
            stb.append(this.timeout / 1000L);
            stb.append("s\n");
        } else {
            stb.append(this.timeout);
            stb.append(" conflicts\n");
        }
        stb.append(prefix);
        stb.append("DB Simplification allowed=");
        stb.append(this.isDBSimplificationAllowed);
        stb.append("\n");
        stb.append(prefix);
        stb.append("--- End Solver configuration ---");
        return stb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeBasedTimeout ? this.timeout / 1000L : this.timeout);
    }

    @Override
    public long getTimeoutMs() {
        if (!this.timeBasedTimeout) {
            throw new UnsupportedOperationException("The timeout is given in number of conflicts!");
        }
        return this.timeout;
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        this.constrs.ensure(nb);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        if (this.isSatisfiable(assumps)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return this.isDBSimplificationAllowed;
    }

    @Override
    public void setDBSimplificationAllowed(boolean status) {
        this.isDBSimplificationAllowed = status;
    }

    @Override
    public int nextFreeVarId(boolean reserve) {
        return this.voc.nextFreeVarId(reserve);
    }

    @Override
    public IConstr addBlockingClause(IVecInt literals) throws ContradictionException {
        return this.addClause(literals);
    }

    @Override
    public void unset(int p) {
        if (this.voc.isUnassigned(p) || this.trail.isEmpty()) {
            return;
        }
        int current = this.trail.last();
        while (current != p) {
            this.undoOne();
            if (this.trail.isEmpty()) {
                return;
            }
            current = this.trail.last();
        }
        this.undoOne();
        this.qhead = this.trail.size();
    }

    @Override
    public void setLogPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getLogPrefix() {
        return this.prefix;
    }

    @Override
    public IVecInt unsatExplanation() {
        VecInt copy = new VecInt(this.unsatExplanationInTermsOfAssumptions.size());
        this.unsatExplanationInTermsOfAssumptions.copyTo(copy);
        return copy;
    }

    @Override
    public int[] modelWithInternalVariables() {
        int[] nmodel;
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        if (this.nVars() == this.realNumberOfVariables()) {
            nmodel = new int[this.model.length];
            System.arraycopy(this.model, 0, nmodel, 0, nmodel.length);
        } else {
            nmodel = new int[this.fullmodel.length];
            System.arraycopy(this.fullmodel, 0, nmodel, 0, nmodel.length);
        }
        return nmodel;
    }

    @Override
    public int realNumberOfVariables() {
        return this.voc.nVars();
    }

    static interface ISimplifier
    extends Serializable {
        public void simplify(IVecInt var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface LearnedConstraintsDeletionStrategy
    extends Serializable {
        public void init();

        public ConflictTimer getTimer();

        public void reduce(IVec<Constr> var1);

        public void onConflict(Constr var1);

        public void onConflictAnalysis(Constr var1);
    }
}

