/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.LimitedLearning;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActiveLearning<D extends DataStructureFactory>
extends LimitedLearning<D> {
    private static final long serialVersionUID = 1L;
    private double percent;
    private IOrder order;
    private int maxpercent;

    public ActiveLearning() {
        this(0.95);
    }

    public ActiveLearning(double d) {
        this.percent = d;
    }

    public void setOrder(IOrder order) {
        this.order = order;
    }

    @Override
    public void setSolver(Solver<D> s2) {
        super.setSolver(s2);
        this.order = s2.getOrder();
    }

    public void setActivityPercent(double d) {
        this.percent = d;
    }

    public double getActivityPercent() {
        return this.percent;
    }

    @Override
    protected boolean learningCondition(Constr clause) {
        int nbactivevars = 0;
        int i = 0;
        while (i < clause.size()) {
            if (this.order.varActivity(clause.get(i)) > 1.0) {
                ++nbactivevars;
            }
            ++i;
        }
        return (double)nbactivevars > (double)clause.size() * this.percent;
    }

    public String toString() {
        return new StringBuffer("Limit learning to clauses containing active literals (").append(this.percent * 100.0).append("%)").toString();
    }

    public void setLimit(int percent) {
        this.maxpercent = percent;
    }

    public int getLimit() {
        return this.maxpercent;
    }
}

