/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.util.Random;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;

public class RandomWalkDecorator
implements IOrder {
    private final VarOrderHeap decorated;
    private final double p;
    private final Random rand = new Random(123456789L);
    private ILits voc;
    private int nbRandomWalks;

    public RandomWalkDecorator(VarOrderHeap order) {
        this(order, 0.01);
    }

    public RandomWalkDecorator(VarOrderHeap order, double p) {
        this.decorated = order;
        this.p = p;
    }

    public void assignLiteral(int q) {
        this.decorated.assignLiteral(q);
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.decorated.getPhaseSelectionStrategy();
    }

    public void init() {
        this.decorated.init();
    }

    public void printStat(PrintWriter out, String prefix) {
        out.println(String.valueOf(prefix) + "random walks\t: " + this.nbRandomWalks);
        this.decorated.printStat(out, prefix);
    }

    public int select() {
        if (this.rand.nextDouble() < this.p) {
            while (!this.decorated.heap.empty()) {
                int max2 = this.decorated.heap.size();
                int var = this.decorated.heap.get(this.rand.nextInt(max2) + 1);
                int lit = this.getPhaseSelectionStrategy().select(var);
                if (!this.voc.isUnassigned(lit)) continue;
                ++this.nbRandomWalks;
                return lit;
            }
        }
        return this.decorated.select();
    }

    public void setLits(ILits lits) {
        this.decorated.setLits(lits);
        this.voc = lits;
        this.nbRandomWalks = 0;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy strategy) {
        this.decorated.setPhaseSelectionStrategy(strategy);
    }

    public void setVarDecay(double d) {
        this.decorated.setVarDecay(d);
    }

    public void undo(int x) {
        this.decorated.undo(x);
    }

    public void updateVar(int q) {
        this.decorated.updateVar(q);
    }

    public double varActivity(int q) {
        return this.decorated.varActivity(q);
    }

    public void varDecayActivity() {
        this.decorated.varDecayActivity();
    }

    public void updateVarAtDecisionLevel(int q) {
        this.decorated.updateVarAtDecisionLevel(q);
    }

    public String toString() {
        return String.valueOf(this.decorated.toString()) + " with random walks " + this.p;
    }
}

