/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.opt.AbstractSelectorVariablesDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public final class MaxSatDecorator
extends AbstractSelectorVariablesDecorator {
    private static final long serialVersionUID = 1L;
    private final IVecInt lits = new VecInt();
    private int counter;
    private IConstr prevConstr;

    public MaxSatDecorator(ISolver solver) {
        super(solver);
    }

    public void setExpectedNumberOfClauses(int nb) {
        super.setExpectedNumberOfClauses(nb);
        this.lits.ensure(nb);
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        int newvar = this.nextFreeVarId(true);
        this.lits.push(newvar);
        literals.push(newvar);
        return super.addClause(literals);
    }

    public void reset() {
        this.lits.clear();
        super.reset();
        this.prevConstr = null;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.calculateObjectiveValue();
        return new Integer(this.counter);
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.prevConstr != null) {
            super.removeSubsumedConstr(this.prevConstr);
        }
        try {
            this.prevConstr = super.addAtMost(this.lits, this.counter - 1);
        }
        catch (ContradictionException ce) {
            this.isSolutionOptimal = true;
            throw ce;
        }
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        boolean result2 = super.admitABetterSolution(assumps);
        if (!result2 && this.prevConstr != null) {
            super.removeConstr(this.prevConstr);
            this.prevConstr = null;
        }
        return result2;
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public Number getObjectiveValue() {
        return new Integer(this.counter);
    }

    void calculateObjectiveValue() {
        this.counter = 0;
        int[] nArray = this.prevfullmodel;
        int n = this.prevfullmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            if (q > this.nVars()) {
                ++this.counter;
            }
            ++n2;
        }
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        super.addAtMost(this.lits, forcedValue.intValue());
    }
}

