/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.GateTranslator;

public class AIGReader
extends Reader {
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private final GateTranslator solver;
    private int maxvarid;
    private int nbinputs;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.reader.AIGReader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    AIGReader(ISolver s2) {
        this.solver = new GateTranslator(s2);
    }

    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.nbinputs) {
            stb.append(model[i] > 0 ? 1 : 0);
            ++i;
        }
        return stb.toString();
    }

    public void decode(int[] model, PrintWriter out) {
        int i = 0;
        while (i < this.nbinputs) {
            out.print(model[i] > 0 ? 1 : 0);
            ++i;
        }
    }

    int parseInt(InputStream in, char expected) throws IOException, ParseFormatException {
        int ch = in.read();
        if (ch < 48 || ch > 57) {
            throw new ParseFormatException("expected digit");
        }
        int res = ch - 48;
        while ((ch = in.read()) >= 48 && ch <= 57) {
            res = 10 * res + (ch - 48);
        }
        if (ch != expected) {
            throw new ParseFormatException("unexpected character");
        }
        return res;
    }

    public IProblem parseInstance(InputStream in) throws ParseFormatException, ContradictionException, IOException {
        if (in.read() != 97 || in.read() != 105 || in.read() != 103 || in.read() != 32) {
            throw new ParseFormatException("AIG format only!");
        }
        this.maxvarid = this.parseInt(in, ' ');
        this.nbinputs = this.parseInt(in, ' ');
        int nblatches = this.parseInt(in, ' ');
        if (nblatches > 0) {
            throw new ParseFormatException("CNF conversion cannot handle latches!");
        }
        int nboutputs = this.parseInt(in, ' ');
        if (nboutputs > 1) {
            throw new ParseFormatException("CNF conversion allowed for single output circuit only!");
        }
        int nbands = this.parseInt(in, '\n');
        this.solver.newVar(this.maxvarid + 1);
        this.solver.setExpectedNumberOfClauses(3 * nbands + 2);
        if (nboutputs > 0) {
            if (!$assertionsDisabled && nboutputs != 1) {
                throw new AssertionError();
            }
            int output0 = this.parseInt(in, '\n');
            this.readAnd(nbands, output0, in, 2 * (this.nbinputs + 1));
        }
        return this.solver;
    }

    static int safeGet(InputStream in) throws IOException, ParseFormatException {
        int ch = in.read();
        if (ch == -1) {
            throw new ParseFormatException("AIG Error, EOF met too early");
        }
        return ch;
    }

    static int decode(InputStream in) throws IOException, ParseFormatException {
        int ch;
        int x = 0;
        int i = 0;
        while (((ch = AIGReader.safeGet(in)) & 0x80) > 0) {
            System.out.println("=>" + ch);
            x |= (ch & 0x7F) << 7 * i++;
        }
        return x | ch << 7 * i;
    }

    private void readAnd(int nbands, int output0, InputStream in, int startid) throws ContradictionException, IOException, ParseFormatException {
        int lhs = startid;
        int i = 0;
        while (i < nbands) {
            int delta0 = AIGReader.decode(in);
            int delta1 = AIGReader.decode(in);
            int rhs0 = lhs - delta0;
            int rhs1 = rhs0 - delta1;
            this.solver.and(this.toDimacs(lhs), this.toDimacs(rhs0), this.toDimacs(rhs1));
            lhs += 2;
            ++i;
        }
        this.solver.gateTrue(this.maxvarid + 1);
        this.solver.gateTrue(this.toDimacs(output0));
    }

    private int toDimacs(int v) {
        if (v == 0) {
            return -(this.maxvarid + 1);
        }
        if (v == 1) {
            return this.maxvarid + 1;
        }
        int var = v >> 1;
        if ((v & 1) == 0) {
            return var;
        }
        return -var;
    }
}

