/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.reader.ParseFormatException;

public class EfficientScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TAILLE_BUF = 16384;
    private final transient BufferedInputStream in;
    private static final char EOF = '\uffff';
    private final char commentChar;

    public EfficientScanner(InputStream input2, char commentChar) {
        this.in = new BufferedInputStream(input2, 16384);
        this.commentChar = commentChar;
    }

    public EfficientScanner(InputStream input2) {
        this(input2, 'c');
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void skipComments() throws IOException {
        char currentChar;
        while ((currentChar = this.currentChar()) == this.commentChar) {
            this.skipRestOfLine();
            if (currentChar != '\uffff') continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextInt() throws IOException, ParseFormatException {
        int n;
        int val = 0;
        boolean neg = false;
        char currentChar = this.skipSpaces();
        if (currentChar == '-') {
            neg = true;
            currentChar = (char)this.in.read();
        } else if (currentChar == '+') {
            currentChar = (char)this.in.read();
        } else {
            if (currentChar < '0') throw new ParseFormatException("Unknown character " + currentChar);
            if (currentChar > '9') throw new ParseFormatException("Unknown character " + currentChar);
            val = currentChar - 48;
            currentChar = (char)this.in.read();
        }
        while (currentChar >= '0' && currentChar <= '9') {
            val = val * 10 + currentChar - 48;
            currentChar = (char)this.in.read();
        }
        if (currentChar == '\r') {
            this.in.read();
        }
        if (neg) {
            n = -val;
            return n;
        }
        n = val;
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger nextBigInteger() throws IOException, ParseFormatException {
        block3: {
            block2: {
                block1: {
                    stb = new StringBuffer();
                    currentChar = this.skipSpaces();
                    if (currentChar != '-') break block1;
                    stb.append(currentChar);
                    currentChar = (char)this.in.read();
                    ** GOTO lbl24
                }
                if (currentChar != '+') break block2;
                currentChar = (char)this.in.read();
                ** GOTO lbl24
            }
            if (currentChar < '0' || currentChar > '9') break block3;
            stb.append(currentChar);
            currentChar = (char)this.in.read();
            if (true) ** GOTO lbl24
        }
        throw new ParseFormatException("Unknown character " + currentChar);
        do {
            stb.append(currentChar);
            currentChar = (char)this.in.read();
lbl24:
            // 4 sources

        } while (currentChar >= '0' && currentChar <= '9');
        return new BigInteger(stb.toString());
    }

    public String next() throws IOException, ParseFormatException {
        StringBuffer stb = new StringBuffer();
        char currentChar = this.skipSpaces();
        while (currentChar != ' ' && currentChar != '\n') {
            stb.append(currentChar);
            currentChar = (char)this.in.read();
        }
        return stb.toString();
    }

    public char skipSpaces() throws IOException {
        char car;
        while ((car = (char)this.in.read()) == ' ' || car == '\n') {
        }
        return car;
    }

    public String nextLine() throws IOException {
        char car;
        StringBuffer stb = new StringBuffer();
        do {
            car = (char)this.in.read();
            stb.append(car);
        } while (car != '\n' && car != '\uffff');
        return stb.toString();
    }

    public void skipRestOfLine() throws IOException {
        char car;
        while ((car = (char)this.in.read()) != '\n' && car != '\uffff') {
        }
    }

    public boolean eof() throws IOException {
        return this.currentChar() == '\uffff';
    }

    public char currentChar() throws IOException {
        this.in.mark(10);
        char car = (char)this.in.read();
        this.in.reset();
        return car;
    }
}

