/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.ObjectInputStream;
import java.io.PrintWriter;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.AbstractOutputSolver;

public class DimacsOutputSolver
extends AbstractOutputSolver {
    private static final long serialVersionUID = 1L;
    private transient PrintWriter out;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.DimacsOutputSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DimacsOutputSolver() {
        this(new PrintWriter(System.out, true));
    }

    public DimacsOutputSolver(PrintWriter pw) {
        this.out = pw;
    }

    private void readObject(ObjectInputStream stream) {
        this.out = new PrintWriter(System.out, true);
    }

    public int newVar() {
        return 0;
    }

    public int newVar(int howmany) {
        this.out.print("p cnf " + howmany);
        this.nbvars = howmany;
        return 0;
    }

    public void setExpectedNumberOfClauses(int nb) {
        this.out.println(" " + nb);
        this.nbclauses = nb;
        this.fixedNbClauses = true;
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.out.println(" XXXXXX");
            }
            this.firstConstr = false;
        }
        IteratorInt iterator2 = literals.iterator();
        while (iterator2.hasNext()) {
            this.out.print(String.valueOf(iterator2.next()) + " ");
        }
        this.out.println("0");
        return null;
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        if (!$assertionsDisabled && degree != 1) {
            throw new AssertionError();
        }
        if (this.firstConstr) {
            if (!this.fixedNbClauses) {
                this.out.println("XXXXXX");
            }
            this.firstConstr = false;
        }
        int i = 0;
        while (i <= literals.size()) {
            int j = i + 1;
            while (j < literals.size()) {
                this.out.println(-literals.get(i) + " " + -literals.get(j) + " 0");
                ++j;
            }
            ++i;
        }
        return null;
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        if (degree > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + degree);
        }
        if (!$assertionsDisabled && degree != 1) {
            throw new AssertionError();
        }
        return this.addClause(literals);
    }

    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        if (n > 1) {
            throw new UnsupportedOperationException("Not a clausal problem! degree " + n);
        }
        if (!$assertionsDisabled && n != 1) {
            throw new AssertionError();
        }
        this.addAtMost(literals, n);
        this.addAtLeast(literals, n);
        return null;
    }

    public void reset() {
        this.fixedNbClauses = false;
        this.firstConstr = true;
    }

    public String toString(String prefix) {
        return "Dimacs output solver";
    }

    public int nConstraints() {
        return this.nbclauses;
    }

    public int nVars() {
        return this.nbvars;
    }

    public int nextFreeVarId(boolean reserve) {
        if (reserve) {
            return ++this.nbvars;
        }
        return this.nbvars + 1;
    }

    public int[] modelWithInternalVariables() {
        throw new UnsupportedOperationException();
    }

    public int realNumberOfVariables() {
        return this.nbvars;
    }

    public void registerLiteral(int p) {
        throw new UnsupportedOperationException();
    }
}

