/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.sat4j.core.Vec;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotSearchTracing<T>
implements SearchListener {
    private static final long serialVersionUID = 1L;
    private final Vec<String> pile = new Vec();
    private String currentNodeName = null;
    private transient Writer out;
    private boolean estOrange = false;
    private final Map<Integer, T> mapping;

    public DotSearchTracing(String fileNameToSave, Map<Integer, T> mapping) {
        this.mapping = mapping;
        try {
            this.out = new FileWriter(fileNameToSave);
        }
        catch (IOException iOException) {
            System.err.println("Problem when created file.");
        }
    }

    private String node(int dimacs) {
        int var;
        T t;
        if (this.mapping != null && (t = this.mapping.get(new Integer(var = Math.abs(dimacs)))) != null) {
            if (dimacs > 0) {
                return t.toString();
            }
            return new StringBuffer("-").append(t.toString()).toString();
        }
        return Integer.toString(dimacs);
    }

    @Override
    public final void assuming(int p) {
        String newName;
        int absP = Math.abs(p);
        if (this.currentNodeName == null) {
            newName = new StringBuffer().append(absP).toString();
            this.pile.push(newName);
            this.saveLine(this.lineTab(new StringBuffer("\"").append(newName).append("\"").append("[label=\"").append(this.node(p)).append("\", shape=circle, color=blue, style=filled]").toString()));
        } else {
            newName = this.currentNodeName;
            this.pile.push(newName);
            this.saveLine(this.lineTab(new StringBuffer("\"").append(newName).append("\"").append("[label=\"").append(this.node(p)).append("\", shape=circle, color=blue, style=filled]").toString()));
        }
        this.currentNodeName = newName;
    }

    @Override
    public final void propagating(int p, IConstr reason) {
        String newName = new StringBuffer(String.valueOf(this.currentNodeName)).append(".").append(p).toString();
        if (this.currentNodeName == null) {
            this.saveLine(this.lineTab("\"null\" [label=\"\", shape=point]"));
        }
        String couleur = this.estOrange ? "orange" : "green";
        this.saveLine(this.lineTab(new StringBuffer("\"").append(newName).append("\"").append("[label=\"").append(this.node(p)).append("\",shape=point, color=black]").toString()));
        this.saveLine(this.lineTab(new StringBuffer("\"").append(this.currentNodeName).append("\"").append(" -- ").append("\"").append(newName).append("\"").append("[label=").append("\" ").append(this.node(p)).append("\", fontcolor =").append(couleur).append(", color = ").append(couleur).append(", style = bold]").toString()));
        this.currentNodeName = newName;
        this.estOrange = false;
    }

    @Override
    public final void backtracking(int p) {
        String temp = this.pile.last();
        this.pile.pop();
        this.saveLine(new StringBuffer("\"").append(temp).append("\"").append("--").append("\"").append(this.currentNodeName).append("\"").append("[label=\"\", color=red, style=dotted]").toString());
        this.currentNodeName = temp;
    }

    @Override
    public final void adding(int p) {
        this.estOrange = true;
    }

    @Override
    public final void learn(IConstr clause) {
    }

    @Override
    public final void delete(int[] clause) {
    }

    @Override
    public final void conflictFound(IConstr confl, int dlevel, int trailLevel) {
        this.saveLine(this.lineTab(new StringBuffer("\"").append(this.currentNodeName).append("\" [label=\"\", shape=box, color=\"red\", style=filled]").toString()));
    }

    @Override
    public final void conflictFound(int p) {
        this.saveLine(this.lineTab(new StringBuffer("\"").append(this.currentNodeName).append("\" [label=\"\", shape=box, color=\"red\", style=filled]").toString()));
    }

    @Override
    public final void solutionFound() {
        this.saveLine(this.lineTab(new StringBuffer("\"").append(this.currentNodeName).append("\" [label=\"\", shape=box, color=\"green\", style=filled]").toString()));
    }

    @Override
    public final void beginLoop() {
    }

    @Override
    public final void start() {
        this.saveLine("graph G {");
    }

    @Override
    public final void end(Lbool result2) {
        this.saveLine("}");
    }

    private final String lineTab(String line) {
        return new StringBuffer("\t").append(line).toString();
    }

    private final void saveLine(String line) {
        try {
            this.out.write(new StringBuffer(String.valueOf(line)).append('\n').toString());
            if ("}".equals(line)) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.out = new PrintWriter(System.out);
    }

    @Override
    public void restarting() {
    }

    @Override
    public void backjump(int backjumpLevel) {
    }
}

