/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.Binomial;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Commander
extends EncodingStrategyAdapter {
    public IConstr addAtMostOne(ISolver solver, IVecInt literals) throws ContradictionException {
        return this.addAtMostOne(solver, literals, 3);
    }

    private IConstr addAtMostOne(ISolver solver, IVecInt literals, int groupSize) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        VecInt clause = new VecInt();
        VecInt clause1 = new VecInt();
        int n = literals.size();
        int nbGroup = (int)Math.ceil((double)literals.size() / (double)groupSize);
        if (nbGroup == 1) {
            int i = 0;
            while (i < literals.size() - 1) {
                int j = i + 1;
                while (j < literals.size()) {
                    clause.push(-literals.get(i));
                    clause.push(-literals.get(j));
                    constrGroup.add(solver.addClause(clause));
                    clause.clear();
                    ++j;
                }
                ++i;
            }
            return constrGroup;
        }
        int[] c = new int[nbGroup];
        int i = 0;
        while (i < nbGroup) {
            c[i] = solver.nextFreeVarId(true);
            ++i;
        }
        int nbVarLastGroup = n - (nbGroup - 1) * groupSize;
        int i2 = 0;
        while (i2 < nbGroup) {
            int size2 = 0;
            size2 = i2 == nbGroup - 1 ? nbVarLastGroup : groupSize;
            int j = 0;
            while (j < size2 - 1) {
                int k = j + 1;
                while (k < size2) {
                    clause.push(-literals.get(i2 * groupSize + j));
                    clause.push(-literals.get(i2 * groupSize + k));
                    constrGroup.add(solver.addClause(clause));
                    clause.clear();
                    ++k;
                }
                ++j;
            }
            clause1.push(-c[i2]);
            j = 0;
            while (j < size2) {
                clause1.push(literals.get(i2 * groupSize + j));
                clause.push(c[i2]);
                clause.push(-literals.get(i2 * groupSize + j));
                constrGroup.add(solver.addClause(clause));
                clause.clear();
                ++j;
            }
            constrGroup.add(solver.addClause(clause1));
            clause1.clear();
            ++i2;
        }
        constrGroup.add(this.addAtMostOne(solver, new VecInt(c), groupSize));
        return constrGroup;
    }

    public IConstr addAtMost(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        return super.addAtMost(solver, literals, degree);
    }

    private IConstr addAtMost(ISolver solver, IVecInt literals, int k, int groupSize) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        VecInt clause = new VecInt();
        int n = literals.size();
        int nbGroup = (int)Math.ceil((double)n / (double)groupSize);
        if (nbGroup == 1) {
            IVecInt[] iVecIntArray = literals.subset(k + 1);
            int n2 = iVecIntArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IVecInt vec = iVecIntArray[n3];
                int i = 0;
                while (i < vec.size()) {
                    clause.push(-vec.get(i));
                    ++i;
                }
                constrGroup.add(solver.addClause(clause));
                clause.clear();
                ++n3;
            }
            return constrGroup;
        }
        int[][] c = new int[nbGroup][k];
        VecInt vecC = new VecInt();
        int i = 0;
        while (i < nbGroup - 1) {
            int j = 0;
            while (j < k) {
                c[i][j] = solver.nextFreeVarId(true);
                vecC.push(c[i][j]);
                ++j;
            }
            ++i;
        }
        int nbVarLastGroup = n - (nbGroup - 1) * groupSize;
        int nbCForLastGroup = k;
        int j = 0;
        while (j < nbCForLastGroup) {
            c[nbGroup - 1][j] = solver.nextFreeVarId(true);
            vecC.push(c[nbGroup - 1][j]);
            ++j;
        }
        VecInt[] groupTab = new VecInt[nbGroup];
        int i2 = 0;
        while (i2 < nbGroup - 1) {
            groupTab[i2] = new VecInt();
            int size2 = 0;
            size2 = i2 == nbGroup - 1 ? nbVarLastGroup : groupSize;
            int j2 = 0;
            while (j2 < size2) {
                groupTab[i2].push(literals.get(i2 * groupSize + j2));
                ++j2;
            }
            j2 = 0;
            while (j2 < k) {
                groupTab[i2].push(-c[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        int size3 = nbVarLastGroup;
        groupTab[nbGroup - 1] = new VecInt();
        int j3 = 0;
        while (j3 < size3) {
            groupTab[nbGroup - 1].push(literals.get((nbGroup - 1) * groupSize + j3));
            ++j3;
        }
        j3 = 0;
        while (j3 < nbCForLastGroup) {
            groupTab[nbGroup - 1].push(-c[nbGroup - 1][j3]);
            ++j3;
        }
        Binomial bin = new Binomial();
        int i3 = 0;
        while (i3 < nbGroup) {
            constrGroup.add(bin.addAtMost(solver, groupTab[i3], k));
            System.out.println(constrGroup.getConstr(i3).size());
            ++i3;
        }
        i3 = 0;
        while (i3 < nbGroup) {
            constrGroup.add(bin.addAtLeast(solver, groupTab[i3], k));
            System.out.println(constrGroup.getConstr(i3 + nbGroup).size());
            ++i3;
        }
        i3 = 0;
        while (i3 < nbGroup) {
            int j4 = 0;
            while (j4 < k - 1) {
                clause.push(-c[i3][j4]);
                clause.push(c[i3][j4 + 1]);
                constrGroup.add(solver.addClause(clause));
                clause.clear();
                ++j4;
            }
            ++i3;
        }
        constrGroup.add(this.addAtMost(solver, vecC, k));
        return constrGroup;
    }
}

