/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.Map;
import java.util.Set;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickXplainStrategy
implements MinimizationStrategy {
    private boolean computationCanceled;

    @Override
    public void cancelExplanationComputation() {
        this.computationCanceled = true;
    }

    @Override
    public IVecInt explain(ISolver solver, Map<Integer, ?> constrs, IVecInt assumps) throws TimeoutException {
        this.computationCanceled = false;
        VecInt encodingAssumptions = new VecInt(constrs.size() + assumps.size());
        assumps.copyTo(encodingAssumptions);
        IVecInt firstExplanation = solver.unsatExplanation();
        VecInt results = new VecInt(firstExplanation.size());
        if (firstExplanation.size() == 1) {
            results.push(-firstExplanation.get(0));
            return results;
        }
        if (solver.isVerbose()) {
            System.out.print(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("initial unsat core ").toString());
            firstExplanation.sort();
            IteratorInt it = firstExplanation.iterator();
            while (it.hasNext()) {
                System.out.print(constrs.get(new Integer(-it.next())));
                System.out.print(" ");
            }
            System.out.println();
        }
        int i = 0;
        while (i < firstExplanation.size()) {
            if (assumps.contains(firstExplanation.get(i))) {
                firstExplanation.delete(i);
                continue;
            }
            ++i;
        }
        Set<Integer> constraintsVariables = constrs.keySet();
        VecInt remainingVariables = new VecInt(constraintsVariables.size());
        for (Integer v : constraintsVariables) {
            remainingVariables.push(v);
        }
        IteratorInt it = firstExplanation.iterator();
        while (it.hasNext()) {
            int p = it.next();
            if (p < 0) {
                p = -p;
            }
            remainingVariables.remove(p);
            encodingAssumptions.push(p);
        }
        int unsatcorelimit = encodingAssumptions.size() - 1;
        remainingVariables.copyTo(encodingAssumptions);
        this.computeExplanation(solver, constrs, encodingAssumptions, assumps.size(), unsatcorelimit, results);
        return results;
    }

    private void computeExplanation(ISolver solver, Map<Integer, ?> constrs, IVecInt encodingAssumptions, int start, int end, IVecInt result2) throws TimeoutException {
        int j;
        if (solver.isVerbose()) {
            System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("qxplain ").append(start).append("/").append(end).toString());
        }
        if (!solver.isSatisfiable(encodingAssumptions)) {
            return;
        }
        if (start == end) {
            result2.push(encodingAssumptions.get(start));
            encodingAssumptions.set(start, -encodingAssumptions.get(start));
            if (solver.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append(constrs.get(new Integer(-encodingAssumptions.get(start)))).append(" is mandatory ").toString());
            }
            return;
        }
        int split2 = (end + start) / 2;
        if (split2 < end) {
            j = start;
            while (j <= split2) {
                encodingAssumptions.set(j, -encodingAssumptions.get(j));
                ++j;
            }
            this.computeExplanation(solver, constrs, encodingAssumptions, split2 + 1, end, result2);
        }
        if (start <= split2) {
            j = start;
            while (j <= split2) {
                encodingAssumptions.set(j, -encodingAssumptions.get(j));
                ++j;
            }
            this.computeExplanation(solver, constrs, encodingAssumptions, start, split2, result2);
        }
        if (this.computationCanceled) {
            throw new TimeoutException();
        }
    }

    public String toString() {
        return "QuickXplain (AAAI 2004 version) minimization strategy";
    }
}

