// PANDA 3 -- a domain-independent planner for classical and hierarchical planning
// Copyright (C) 2014-2018 the original author or authors.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package de.uniulm.ki.panda3.symbolic.parser.xml.problem;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;


/**
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
        "variableOrConstant"
})
@XmlRootElement(name = "atomic")
public class Atomic {

    @XmlAttribute(name = "relation", required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String relation;
    @XmlElements({
            @XmlElement(name = "variable", type = Variable.class),
            @XmlElement(name = "constant", type = Constant.class)
    })
    protected List<Object> variableOrConstant;

    /**
     * Ruft den Wert der relation-Eigenschaft ab.
     *
     * @return possible object is
     * {@link String }
     */
    public String getRelation() {
        return relation;
    }

    /**
     * Legt den Wert der relation-Eigenschaft fest.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setRelation(String value) {
        this.relation = value;
    }

    /**
     * Gets the value of the variableOrConstant property.
     * <p>
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the variableOrConstant property.
     * <p>
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVariableOrConstant().add(newItem);
     * </pre>
     * <p>
     * <p>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Variable }
     * {@link Constant }
     */
    public List<Object> getVariableOrConstant() {
        if (variableOrConstant == null) {
            variableOrConstant = new ArrayList<Object>();
        }
        return this.variableOrConstant;
    }

}
