# Merges two sorted lists into one
merge = xs => ys => if isnil xs || isnil ys
                    then xs ++ ys
                    else if head xs <= head ys
                    then head xs : merge (tail xs) ys
                    else head ys : merge xs (tail ys);

# Sorts a list by performing a merge-sort
sort = xs => if isnil xs || isnil (tail xs)
             then xs
             else merge (sort (evens xs))
                        (sort (tail (evens xs)));

# Recursive list implementation
type List a = Nil | Cons a (List a);

`:`   = Cons;

# concatenates two list
`++`  = xs => ys => if isnil xs
                    then ys
                    else if isnil ys
                         then xs
                         else head xs : (tail xs ++ ys);

# applies a function to all elements of a list
map   = f => xs => if isnil xs
                   then []
                   else f (head xs) : map f (tail xs);

# checks whether a list is empty
isnil = xs => case xs of Nil      => True
                      of Cons h t => False;

# returns the first element of a list
head  = xs => case xs of Cons h t => h;

# returns a sublist starting with the second element
tail = xs => case xs of Cons h t => t;

# returns a sublist containing all even indices
evens = xs => if isnil xs || isnil (tail xs)
              then xs
              else head xs : evens (tail (tail xs));

###



















