{-# LANGUAGE GADTs,
             StandaloneDeriving,
             DataKinds,
             KindSignatures #-}
--------------------------------------------------------------------------------
module Flux.Typed.Literal where
--------------------------------------------------------------------------------
import Flux.Typed.Type
import Data.Proxy
import Data.Type.Equality
--------------------------------------------------------------------------------
-- | Some basic kinds of literals. We do not distinguish between different types
-- of integers, floats, etc.
data Lit :: TypeKind -> * where
    LitSymbol      :: String  -> Lit (TyForAll "a" (TyVar "a"))
    LitPrimChar    :: Char    -> Lit PrimChar
    LitPrimString  :: String  -> Lit PrimString
    LitPrimInt     :: Integer -> Lit PrimInt
    LitPrimDouble  :: Double  -> Lit PrimDouble
    LitPrimFloat   :: Float   -> Lit PrimFloat
    LitInteger     :: Integer -> Lit TypeInteger
    LitChar        :: Char    -> Lit TypeChar
    LitString      :: String  -> Lit TypeString
    LitInt         :: Integer -> Lit TypeInt
    LitDouble      :: Double  -> Lit TypeDouble
    LitFloat       :: Float   -> Lit TypeFloat
--------------------------------------------------------------------------------
deriving instance Eq (Lit t)
--------------------------------------------------------------------------------
instance TestEquality Lit where
  testEquality (LitSymbol _) (LitSymbol _)         = Just Refl
  testEquality (LitPrimChar _) (LitPrimChar _)     = Just Refl
  testEquality (LitPrimString _) (LitPrimString _) = Just Refl
  testEquality (LitPrimInt _) (LitPrimInt _)       = Just Refl
  testEquality (LitPrimDouble _) (LitPrimDouble _) = Just Refl
  testEquality (LitPrimFloat _) (LitPrimFloat _)   = Just Refl
  testEquality (LitInteger _) (LitInteger _)       = Just Refl
  testEquality (LitChar _) (LitChar _)             = Just Refl
  testEquality (LitString _) (LitString _)         = Just Refl
  testEquality (LitInt _) (LitInt _)               = Just Refl
  testEquality (LitDouble _) (LitDouble _)         = Just Refl
  testEquality (LitFloat _) (LitFloat _)           = Just Refl
  testEquality _ _                                 = Nothing
--------------------------------------------------------------------------------
instance Show (Lit t) where
  show (LitSymbol s)      = s
  show (LitPrimChar c)    = show c ++ "#"
  show (LitPrimString s)  = show s ++ "#"
  show (LitPrimInt i)     = show i ++ "#"
  show (LitPrimDouble d)  = show d ++ "#"
  show (LitPrimFloat f)   = show f ++ "#"
  show (LitInteger i)     = show i
  show (LitChar c)        = show c
  show (LitString s)      = show s
  show (LitInt i)         = show i
  show (LitDouble d)      = show d
  show (LitFloat f)       = show f
--------------------------------------------------------------------------------
instance Typed Lit where
  typeOf (LitSymbol _)     = TypeForAll Proxy (TypeVar Proxy)
  typeOf (LitPrimChar _)   = typePrimChar
  typeOf (LitPrimString _) = typePrimString
  typeOf (LitPrimInt _)    = typePrimInt
  typeOf (LitPrimDouble _) = typePrimDouble
  typeOf (LitPrimFloat _)  = typePrimFloat
  typeOf (LitInteger _)    = typeInteger
  typeOf (LitChar _)       = typeChar
  typeOf (LitString _)     = typeString
  typeOf (LitInt _)        = typeInt
  typeOf (LitDouble _)     = typeDouble
  typeOf (LitFloat _)      = typeFloat
--------------------------------------------------------------------------------
