{-# LANGUAGE StandaloneDeriving,
             GADTs,
             DataKinds,
             KindSignatures #-}
--------------------------------------------------------------------------------
module Flux.Typed.Var(Var(..), VarName, Arity, Scope(..),
  isVar, isCons, changeVarType, unit, ctrl,
  VarOccurrence(..)) where
--------------------------------------------------------------------------------
import Flux.Typed.Type
import Data.Type.Equality
--------------------------------------------------------------------------------
type VarName = String
type Arity   = Int
--------------------------------------------------------------------------------
data Scope = Global | Local deriving (Eq,Ord,Show)
--------------------------------------------------------------------------------
-- | Representation of variables, including real variables and data constructors.
data Var t where
  Var :: GenType t =>
         {varType  :: Type t,
          varName  :: VarName,
          varScope :: Scope} -> Var t

  Cons :: GenType t =>
          {varType  :: Type t,
           varName  :: VarName,
           varScope :: Scope,
           varArity :: Arity} -> Var t
--------------------------------------------------------------------------------
instance Show (Var t) where
  showsPrec _ v = showParen (all (`elem` "!#$%&*+./<=>?@\\^|-~:") (varName v)) (showString (varName v))
--------------------------------------------------------------------------------
deriving instance Eq (Var t)
--------------------------------------------------------------------------------
instance Typed Var where
  typeOf = varType
--------------------------------------------------------------------------------
instance TestEquality Var where
  testEquality v1 v2 = testEquality (varType v1) (varType v2)
--------------------------------------------------------------------------------
isVar, isCons :: Var t -> Bool
isVar (Var {})   = True
isVar _          = False
isCons (Cons {}) = True
isCons _         = False
--------------------------------------------------------------------------------
changeVarType :: GenType t' => Var t -> Type t' -> Var t'
changeVarType v@(Var {}) t  = Var t (varName v) (varScope v)
changeVarType v@(Cons {}) t = Cons t (varName v) (varScope v) (varArity v)
--------------------------------------------------------------------------------
class VarOccurrence (expr :: TypeKind -> *) where
  varOccursIn :: Var t -> expr t' -> Bool

instance VarOccurrence Var where
  varOccursIn u v | Just Refl <- testEquality u v, u == v = True
  varOccursIn _ _ = False
--------------------------------------------------------------------------------
unit :: Var TyUnit
unit = Cons TypeUnit "()" Global 0
--------------------------------------------------------------------------------
ctrl :: Var TyCtrl
ctrl = Var TypeCtrl "#" Local
--------------------------------------------------------------------------------
--uncurryVar :: Var (a :-> (b :-> c)) -> Var (TyTuple a b :-> c)
--uncurryVar v = v {varType = uncurryType (varType v)}
--------------------------------------------------------------------------------
