module Flux.Util where
--------------------------------------------------------------------------------
import Data.Function(on)
import Data.List(unionBy)
--------------------------------------------------------------------------------
modifyFunction :: (Eq a) => (a -> b) -> a -> b -> a -> b
modifyFunction f v p x
  | x == v    = p
  | otherwise = f x

insertKeyValue :: Eq k => (k,v) -> [(k,v)] -> [(k,v)]
insertKeyValue = insertKeyValueWith const

insertKeyValueWith :: Eq k => (v -> v -> v) -> (k,v) -> [(k,v)] -> [(k,v)]
insertKeyValueWith _ x [] = [x]
insertKeyValueWith f x@(k,v) (y@(k',v'):ys)
  | k == k'   = (k, f v v'):ys
  | otherwise = y : insertKeyValueWith f x ys


unionKeyValues :: Eq k => [(k,v)] -> [(k,v)] -> [(k,v)]
unionKeyValues = unionBy ((==) `on` fst)
--------------------------------------------------------------------------------
escapeHtml :: String -> String
escapeHtml = concatMap esc
  where
    esc '|'  = "&#124;"
    esc ','  = "&#44;"
    esc '&'  = "&amp;"
    esc '<'  = "&lt;"
    esc '>'  = "&gt;"
    esc '\"' = "&quot;"
    esc '\\' = "\\\\"
    esc x    = [x]
--------------------------------------------------------------------------------
