/*
    This file is part of SGDAE, a software to numerically solve differential
    algebraic equations using a steepest descent method based on Sobolev 
    gradients.
    You are welcome to contact the authors via e-mail:
        <manfred-sauter [at] gmx [dot] de>
        <robin.nittka [at] gmx [dot] de>

    Copyright 2005-2008 Manfred Sauter, Robin Nittka.

    SGDAE is free software distributed under the terms of the revised BSD 
    license as illustrated on <http://creativecommons.org/licenses/BSD/>.
    For details consult the accompanying LICENSE.txt file.

    $Id: $
*/


#include "logging.h"


namespace logging
{


tLogger::tLogger() : std::ostream(std::cout.rdbuf())
{
	tie(MASK_ALL,  &null_os);

	name[DEBUG] = "DEBUG: ";
	name[INFO] = "INFO: ";
	name[WARNING] = "WARNING: ";
	name[ERROR] = "ERROR: ";
	name[FATAL] = "FATAL: ";
}

void tLogger::tie(const tLogType type, std::ostream *out)
{
	assert(type < LOG_MASK_END);
	if (type == MASK_ALL) for (int i=0; i<LOG_TYPE_END; i++) os[i] = out;
	else
	{
		assert(type < LOG_TYPE_END);
		os[type] = out;
	}
}

std::ostream *tLogger::get_tie(const tLogType type)
{
	assert(type < LOG_TYPE_END);
	return os[type];
}

void tLogger::setName(const tLogType type, const std::string &str)
{
    assert(type < LOG_MASK_END);
    name[type] = str;
}


std::ostream &tLogger::operator ()(const tLogType type)
{
	assert(type < LOG_TYPE_END);
	std::ostream *res = &null_os;
	if (NULL != os[type]) res = os[type];

	if (scope_stack.size()) (*res) << "[";
	for (tVS::const_iterator it=scope_stack.begin(); it!=scope_stack.end(); ++it)
		(*res) << (it != scope_stack.begin() ? ">" : "") << *it;
	if (scope_stack.size()) (*res) << "] ";
	(*res) << name[type];

	return *res;
}

void tLogger::pushScope(const std::string &scope)
{
	scope_stack.push_back(scope);
}

void tLogger::popScope()
{
	if (scope_stack.size()) scope_stack.pop_back();
}

tNull_ostream tLogger::null_os;
tLogger *tLogger::logger = NULL;

};

