/*
    This file is part of SGDAE, a software to numerically solve differential
    algebraic equations using a steepest descent method based on Sobolev 
    gradients.
    You are welcome to contact the authors via e-mail:
        <manfred-sauter [at] gmx [dot] de>
        <robin.nittka [at] gmx [dot] de>

    Copyright 2005-2008 Manfred Sauter, Robin Nittka.

    SGDAE is free software distributed under the terms of the revised BSD 
    license as illustrated on <http://creativecommons.org/licenses/BSD/>.
    For details consult the accompanying LICENSE.txt file.

    $Id: $
*/


#ifndef __TYPE_HEADER__
#define __TYPE_HEADER__

#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/vector_proxy.hpp>
#include <boost/numeric/ublas/vector_sparse.hpp> 
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/banded.hpp>
#include <boost/numeric/ublas/symmetric.hpp>
#include <boost/numeric/ublas/matrix_sparse.hpp>
#include <boost/numeric/ublas/vector_of_vector.hpp>
#include <boost/numeric/ublas/matrix_expression.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/operation.hpp>
#include <boost/numeric/ublas/storage.hpp>
#include <boost/numeric/ublas/io.hpp>

#if 0
// bindings
#include <boost/numeric/bindings/lapack/lapack.hpp>
#include <boost/numeric/bindings/traits/ublas_matrix.hpp> 
#include <boost/numeric/bindings/traits/ublas_symmetric.hpp> 
#include <boost/numeric/bindings/traits/ublas_vector.hpp>
#include <boost/numeric/bindings/traits/ublas_sparse.hpp>
#include <boost/numeric/bindings/umfpack/umfpack.hpp>
#endif

typedef double Real;
typedef utility::PrecInfo<Real> PREC;



namespace ublas = boost::numeric::ublas;
// namespace lapack = boost::numeric::bindings::lapack;
// namespace umf = boost::numeric::bindings::umfpack;


typedef ublas::vector<Real> DenseVector;
typedef ublas::scalar_vector<Real> ScalarVector;


typedef ublas::matrix<Real> DenseMatrix;
typedef ublas::compressed_matrix<Real> SparseMatrix;
typedef ublas::compressed_matrix<Real> SparseSymmetricMatrix;
typedef ublas::compressed_vector<Real> SparseVector;
typedef ublas::generalized_vector_of_vector<Real, ublas::row_major, ublas::vector<SparseVector> > SparseRowMatrix;

typedef ublas::banded_matrix<Real> BandedMatrix;
typedef ublas::identity_matrix<Real> IdentityMatrix;


#endif // __TYPE_HEADER__
