%% Clear workspace, close all figures
close all;
clear all;

%% Set up problem at hand
fem = getInitFem;

%% Determine indices of dof in xmesh NOT belonging to an edge with DBC
fem.custom.dof = getDof(fem);

% small test for this
u = zeros(fem.custom.dof.num,1);
u(fem.custom.dof.ind) = 1;
fem.sol = femsol(u);
figure(1);
postplot(fem,'tridata','u');

%% Pre-assemble quantities
% Omega1
[K1,L] = assemble(fem,'Out',{'C','G'},'const',{'mu1','1','mu2','0'});
% Omega2
K2 = assemble(fem,'Out','C','const',{'mu1','0','mu2','1'});

% extract relevant parts
fem.custom.pre.K1 = K1(fem.custom.dof.ind,fem.custom.dof.ind);
fem.custom.pre.K2 = K2(fem.custom.dof.ind,fem.custom.dof.ind);
fem.custom.pre.L = L(fem.custom.dof.ind);

%% Solve the problem
mu1 = .1;
mu2 = 1;

figure(2);

% Call Comsol to solve problem
fem.const = {'mu1',num2str(mu1,16), ...
             'mu2',num2str(mu2,16)};
fem.sol = femlin(fem);

uDir = fem.sol.u;
subplot(1,3,1);
postplot(fem,'tridata','u');

% Use preassembled quantities

%  ... TBD ...
% K = 
% L =
% u = 
      
fem.sol = femsol(u);
      
uPre = fem.sol.u;
subplot(1,3,2);
postplot(fem,'tridata','u');

fem.sol = femsol(uDir-uPre);
subplot(1,3,3);
postplot(fem,'tridata','u');
