function dof = getDof(fem)
% store total number of dofs
  dof.num = size(fem.mesh.p,2);

% find geometric edge numbers, where DBC are posed
  appl_bnd_type_ind = find(strcmp('dir',fem.appl{1}.bnd.type));
  DBC_geom_edge_ind = find(ismember(fem.appl{1}.bnd.ind,appl_bnd_type_ind));

% find indices of edges (in mesh.e) located on geometric edges from above
  DBC_mesh_edge_ind = find(ismember(fem.mesh.e(5,:),DBC_geom_edge_ind));

% determine indices of points (in mesh.p) defining the mesh edges from above
  DBC_mesh_point_ind = unique(fem.mesh.e(1:2,DBC_mesh_edge_ind));
% all but the above points are the real dof in mesh
  dofs_mesh_ind = setdiff(1:dof.num,DBC_mesh_point_ind);
% due to different numbering in mesh and xmesh
  nodes = xmeshinfo(fem,'out','nodes');
  dofs_xmesh_ind = nodes.dofs(dofs_mesh_ind);
  dof.ind = dofs_xmesh_ind;
