function fem = getInitFem

fem.solform = 'coefficient';

% COMSOL version
clear vrsn
vrsn.name = 'COMSOL 3.5';
vrsn.ext = 'a';
vrsn.major = 0;
vrsn.build = 608;
vrsn.rcs = '$Name: v35ap $';
vrsn.date = '$Date: 2009/05/11 07:38:49 $';
fem.version = vrsn;

% Geometry
g1=rect2(0.5,1,'base','corner','pos',[0,0]);
g2=rect2(0.5,1,'base','corner','pos',[0.5,0]);

% Constants
fem.const = {'mu1','1', ...
  'mu2','1'};

% Analyzed geometry
clear s
s.objs={g1,g2};
s.name={'R1','R2'};
s.tags={'g1','g2'};

fem.draw=struct('s',s);
fem.geom=geomcsg(fem);

% Initialize mesh
fem.mesh = meshinit(fem,'hauto',5);

% Refine mesh
fem.mesh=meshrefine(fem, ...
                    'mcase',0, ...
                    'rmethod','regular');
                
% Application mode 1
clear appl
appl.mode.class = 'FlPDEC';
appl.assignsuffix = '_c';
clear prop
prop.elemdefault='Lag1';
appl.prop = prop;
clear bnd
bnd.g = {0,0,1};
bnd.type = {'dir','neu','neu'};
bnd.ind = [2,3,1,2,3,1,2];
appl.bnd = bnd;
clear equ
equ.f = {'0','0'};
equ.c = {'mu1','mu2'};
equ.be = {{{0;0}},{{0;0}}};
equ.ind = [1,2];
appl.equ = equ;
fem.appl{1} = appl;
fem.frame = {'ref'};
fem.border = 1;
clear units;
units.basesystem = 'SI';
fem.units = units;

% ODE Settings
clear ode
clear units;
units.basesystem = 'SI';
ode.units = units;
fem.ode=ode;
% Multiphysics
fem=multiphysics(fem);

% Extend mesh
fem.xmesh=meshextend(fem);