%define IAZ 48
function  s = mp2DezFrac(a)
% Converts a radix 256 fraction a[1..n] (radix point before a[1]) to a decimal 
% fraction represented as an ascii string s[1..m], where m is a returned value. 
% The input array a[1..n] is destroyed. 
% NOTE: For simplicity, this routine implements a slow O(N^2) algorithm. Fast
% O(N log(N)), more complicated, radix conversion algorithms do exist.

m = fix(2.408*length(a));
s = zeros(1,m);
for j=1:m
  a = mpShortMult(a,10);
  s(j)=a(1) + 48;                % or use s(j) = num2str(a(1),1); 
  a = mpLeftShift(a);
  a(end) = [];
end
s = char(s);