function w = mpAdd(u,v)
% Adds the unsigned radix 256 integer u(1:n) and v(1:n) 
% yielding the unsigned integer w(1:n+1)
n = length(u);
if n ~= length(v)
  error('Input vectors must have the same length!')
end
w = zeros(1,n+1,'uint8');
ireg = 0;
for j=n:-1:1
  ireg = double(u(j)) + double(v(j)) + double(hiByte(ireg));
  w(j+1) = loByte(ireg);
end
w(1) = hiByte(ireg);