function [q,rem] = mpDiv(u,v)
% Divides unsigned radix 256 integers u[1..n] by v[1..m] (with m <= n required), 
% yielding a quotient q[1..n-m+1] and a remainder r[1..m].
MACC = 6;       % Accuracy parameter
n = length(u);
m = length(v);
if (m>n)
  error('Dimensions not possible!');
end

q = zeros(1,n-m+1,'uint8');
s = mpInv(v,n+MACC)                  % Set S = 1 / V.
rr = mpMult(s,u);                    % Set Q = SU.
s = mpShortAdd(rr,1);
q = mpMov(s(3:n-m+3))
rr = mpMult(q,v)                     % Multiply and subtract to get the remainder.
u,rr(2:n+1)
[rr(2:n+1),flag] = mpSub(u,rr(2:n+1));
flag
if flag 
  error('MACC too small in mpDiv!');
end
rem = mpMov(rr(n-m+2:n+1));
