function  u = mpInv(v, n)
% Character string v(1:m) is interpreted as a radix 256 number 
% with the radix point after (nonzero) v(1); 
% u(1:n) is set to the most significant digits of its reciprocal, 
% with the radix point after u(1).
m = length(v);
% if (n>m+3)
%   error('mpInv: Expected precision too high!');
% end

mm = min(4,m);
fv = double(v(mm));                          % Use ordinary floating arithmetic  
fv = sum(double(v(1:mm))./(256.^[0:mm-1]));  % to get an initial approximation.
fu = 1/fv;
for j=1:n
  i=fix(fu);
  u(j)=uint8(i);
  fu=256*double(fu-i);
end

while 1 % Iterate Newton's rule to convergence.
  rr = mpMult(u,v);             % Construct 2 - UV in S.
  s = mpMov(rr(2:n+1));
  s = mpNeg(s);
  s(1) = s(1)-254;              % Multiply SU into U.
  rr = mpMult(s,u);
  u = mpMov(rr(2:n+1));
  if ~sum(find(0~=s(2:end-1)))  % If fractional part of S is not zero, 
    return                      % it has not converged to 1.
  end
end
