function mpPi(n)
% Demonstrate multiple precision routines by calculating and 
% printing the first n bytes of Pi.
if ismember(n,[2,4,8,14])
   n = n+1;
end
t = zeros(1,n,'uint8');
t(1) = 2;                               % Set T = 2
x = mpSqrt(t,n);                        % Set X_0 = sqrt(2)
pi = mpAdd(t,x);                        % Set PI_0 = 2+sqrt(2)
pi = mpMov(pi(2:n+1));
[sx,sxi] = mpSqrt(x,n);                 
y = sx;                                 % Set Y_0 = 2^(1/4)
fprintf('\nIteration im AMG-Algorithmus zur Berechnung von Pi.\n');
while 1
  fprintf('.');
  x = mpAdd(sx,sxi);                    % Set X_(i+1) = (X_i^(1/2) + X_i^(-1/2))/2
  [x,rem] = mpShortDiv(x(2:n+1),2);
  [sx,sxi] = mpSqrt(x,n);               % Form the temporary T = Y_i X_(i+1)^(1/2) + X_(i+1)^(-1/2) .
  t = mpMult(y,sx);
  t(2:n+2) = mpAdd(t(2:n+1),sxi);
  x(1) = x(1) + 1;                      % Increment X_(i+1) and Y_i by 1.
  y(1) = y(1) + 1;
  s = mpInv(y,n);                       % Set Y_(i+1) = T / (Y_i + 1).
  y = mpMult(t(3:n+2),s);
  y = mpMov(y(2:n+1));
  t = mpMult(x(1:n),s(1:n));            % Form temporary T = (X_(i+1) + 1)/(Y_i + 1).
  mm = t(2)-1;                          % If T = 1 then we have converged.
  flag = 0;
  for j=3:n
    if t(j) ~= mm 
      flag = 1;
      break;
    end
  end
  m = t(n+1) - mm;
  if (flag | m > 1 | m < -1) 
    s = mpMult(pi,t(2:n+1));             % Set Pi_(i+1) = T * Pi_i.
    pi = mpMov(s(2:n+1));
    continue;
  end
  fprintf('\npi=\n');
  s = [pi(1)+48,'.',mp2DezFrac(pi(2:n))];
  % Convert to decimal for printing. 
  % NOTE: The conversion routine, for this demonstration only, 
  % is a slow O(N^2) algorithm. Fast O(N*log(N)), more complicated, 
  % radix conversion algorithms do exist.
  while length(s)>0
    r = min(length(s),75);
    fprintf(' %s\n',s(1:r));
    s = s(76:end);
  end
  return;
end
