function w = mpShortAdd(u, iv)
% Short addition: the integer iv (in the range 0 <= iv <=255) is added 
% to the unsigned radix 256 integer u(1:n), yielding w(1:n+1).
n = length(u);
if length(iv) ~=1
  error('Second input must be a scalar!')
end
w = zeros(1,n+1,'uint8');
ireg = 256*double(iv);
for j=n:-1:1
  ireg = double(u(j)) + hiByte(ireg);
  w(j+1) = loByte(ireg);
end
w(1)=hiByte(ireg);