function [w,rem] = mpShortDiv(u, iv)
% Short division: 
% the unsigned radix 256 integer u(1:n) is divided by 
% the integer iv (in the range 0 <= iv <= 255), 
% yielding a quotient w(1:n) and a remainder ir (with 0 <= ir <= 255).
n = length(u);
if length(iv) ~=1
  error('Second input must be a scalar!')
end

w = zeros(1,n,'uint8');
rem = 0;
iv = double(iv);
for j=1:n;
  i = 256 * rem + double(u(j));
  w(j) = uint8(fix(i/iv));
  rem = mod(i,iv);
end
rem = uint8(rem);
