function w = mpShortMult(u, iv)
% Short multiplication: 
% the unsigned radix 256 integer u(1:n) is multiplied 
% by the integer iv (in the range 0 <= iv <= 255), yielding w[1..n+1].
n = length(u);
if length(iv) ~=1
  error('Second input must be a scalar!')
end
w = zeros(1,n+1,'uint8');
ireg=0;
for j=n:-1:1 
  ireg = double(u(j))*double(iv) + double(hiByte(ireg));
  w(j+1) = loByte(ireg);
end
w(1)=hiByte(ireg);
