% define MF 3
% define BI (1.0/256)
function [w,u] = mpSqrt(v, n)
% Character string v[1..m] is interpreted as a radix 256 number with the radix point after v[1];
% w[1..n] is set to its square root (radix point after w[1]), and 
% u[1..n] is set to the reciprocal thereof (radix point before u[1]). 
% w and u need not be distinct, in which case they are set to the square root.

m = length(v);
w = zeros(1,n,'uint8');
u = zeros(1,n,'uint8');

mm=min(m,3);
fv = double(v(mm));                          % Use ordinary floating arithmetic  
fv = sum(double(v(1:mm))./(256.^[0:mm-1]));  % to get an initial approximation.
fu = 1/sqrt(fv);

for j=1:n
  i=fix(fu);
  u(j)=uint8(i);
  fu=256*double(fu-i);
end

while 1                               % Iterate Newton's rule to convergence.
  r = mpMult(u,u);                    % Construct S = (3-VU^2)/2.
  r = mpMov(r(2:n+1));
  s = mpMult(r,v(1:min(m,n)));
  s = mpMov(s(2:n+1));
  s = mpNeg(s);
  s(1) = s(1) - 253;
  [s,rem] = mpShortDiv(s,2);
  flag = 0;
  for j=2:n-1     % If fractional part of s is not zero, it has not converged
    if s(j)       % to 1.
      r = mpMult(s,u);                % Replace U by SU.
      u = mpMov(r(2:n+1));
      flag = 1;
      break; 
    end
  end
  if flag 
    continue;
  end
  r = mpMult(u,v(1:min(m,n)));        % Get square root from reciprocal and return.
  w = mpMov(r(2:n+1));
  return;
end
