clear all
clc


% Die Teile des Programms die Sie noch nicht implementiert haben, sollten
% Sie auskommentieren.

% We have two test cases (see below)
example = 2;

if example == 1
    N = 10;
elseif example == 2
    N = 6;
else
    error('This example does not exist')
end


matrixDimensions= zeros(N,1);

timesCholDecompWOBand = zeros(N,1);
timesCholDecompWBand  = zeros(N,1);


% This loop is required for time measurements for part c) using tic and toc
for k=2:N

    n = 2^k;
    matrixDimensions(k) = n;
    
    

    if example == 1
        display('Processing example 1')
        % ***************** Example 1 ****************
        m = 2;
        e = ones(n,1);
        A = spdiags([-0.125*e -0.25*e 2*e -0.25*e -0.125*e], -2:2, n,n);
        
        % Save matrix in the special storage format from the exercise
        % sheet
        colsA = zeros(n,m+1);
        colsA(:,3) = 2.*e;
        colsA(2:n,2) = -0.25.*e(2:n);
        colsA(3:n,1) = -0.125.*e(3:n);
    elseif example == 2
        display('Processing example 2')
        % ***************** Example 2 ****************
        % We create a random s.p.d. matrix
        m = 3;
        count = 1
        % We try at most 100 times
        while (count <= 100)
            D0 = rand(n,1);
            D1 = rand(n,1);
            D2 = rand(n,1);
            D3 = rand(n,1);
            A = spdiags([[0.125*D3(4:n);0;0;0] [0.25*D2(3:n);0;0] [0.5*D1(2:n);0] 3*D0 0.5*D1 0.25*D2 0.125*D3], -3:3, n,n);
            eigenvalues = eig(full(A));
            lambdamin = min(eigenvalues);
            %[i,j,s]=find(A);
            %[I,J,S]=find(A.');
            %issymetric=isequal([i,j,s], [I,J,S])
            
            % Save matrix in the special storage format from the exercise
            % sheet
            if (min(eigenvalues)>0)
                colsA = zeros(n,m+1);
                colsA(:,4)   = 3*D0;
                colsA(2:n,3) = 0.5*D1(2:n);
                colsA(3:n,2) = 0.25*D2(3:n);
                colsA(4:n,1) = 0.125*D3(4:n);
                break;
            end
            count = count + 1;
        end
    else
        error('This example does not exist')
    end
    
    if (count==100) error('Matrix is not symmetric')
    end


    if (n<10)
        full(A)
        colsA
    end

    % Compute Matlab's reference solution for Cholesky decomposition
    L = chol(A,'lower');
    
    % Compute an exact reference solution for a given (random) vector b
    b = rand(n,1);
    x_exact = A \ b;


    
    % Part a):
    
    % Compute the solution to Ax = b via Cholesky decomposition without using
    % the fact that A is a band matrix.
    tic
    
    % Implement Cholesky
    % ***************************
    L1 = cholesky(A);
    % ***************************
    y1  = Linvb(L1,b);
    
    x_chol1 = Rinvb(L1',y1);
    timesCholDecompWOBand(k) = toc;
    errorLS1 = norm(x_exact - x_chol1,2);
    fprintf('Error solution of linear system with Cholesky decomposition: %1.16e\n', errorLS1);
    errorCholesky1 = norm(L-L1,2);
    fprintf('Error Cholesky decomposition (method 1): %1.16e\n', errorCholesky1);


    % Part b)
    
    % Compute the solution to Ax = b via Cholesky decomposition using the fact
    % that A is band matrix
    tic
    % Implement Cholesky using band structure
    % ***************************
    L2 = cholesky_band(A,m);
    % ***************************
    
    % Implement forward and backward substitution using band structure
    % ***************************
    y2  = Lbandinvb(L2,b,m);
    x_chol2 = Rbandinvb(L2',y2,m);
    % ***************************
    
    timesCholDecompWBand(k) = toc;
    errorLS2 = norm(x_exact - x_chol2,2);
    fprintf('Error solution of linear system with Cholesky decomposition: %1.16e\n', errorLS2);
    errorCholesky2 = norm(full(L-L2),2);
    fprintf('Error Cholesky decomposition (method 2): %1.16e\n', errorCholesky2);


    % Part d)
    
    % Compute Cholesky decomposition of A using the fact
    % that A is band matrix using the special storage for matrix entries
    % from the exercise sheet.
    
    % Implement Cholesky using band structure and special storage
    % ***************************
    colsL = cholesky_band2(colsA,A);
    % ***************************
    
    % In order to check our implementation, we can use spdiags again. Here,
    % we have to be careful with the positioning of the secondary
    % diagonals. This is why we have to restrict the columns in colsL and
    % have to add zeros at the end.
    if m==1
        L3 = spdiags([[colsL(2:n,1);0] colsL(:,2)], -1:0, n,n);
    elseif m==2
        L3 = spdiags([[colsL(3:n,1);0;0] [colsL(2:n,2);0] colsL(:,3)], -2:0, n,n);
    elseif m==3
       L3 = spdiags([[colsL(4:n,1);0;0;0] [colsL(3:n,2);0;0] [colsL(2:n,3);0] colsL(:,4)], -3:0, n,n);
    else
        error('Creation of band matrix not implemented for m>3.')
    end

    full(L);
    full(L3);
    errorCholesky3 = norm(full(L-L3),2);
    fprintf('Error Cholesky decomposition (method 3): %1.16e\n', errorCholesky3);

end

figure(1)
subplot(211)
plot(matrixDimensions,timesCholDecompWOBand,'-o')
title('Computation times without using band matrix structure') % Insert title
ylabel('n') % Insert y-label
xlabel('CPU time') % Insert x-label


subplot(212)
plot(matrixDimensions,timesCholDecompWBand,'-x')
title('Computation times using band matrix structure') % Insert title
ylabel('n') % Insert y-label
xlabel('CPU time') % Insert x-label



