clear all
clc

n = 3;
A = [2 -1 1; -1 2 -1; 1 -1 2]

eigenvalues = eig(full(A));
b = [2; 0; 2]

x_exact = A \ b

x0 = zeros(n,1);
N  = 20;
omega = linspace(0.25, 0.45, 200);

err = zeros(numel(omega,1));
for k=1:numel(omega)
    x_rich  = richardson(A, b, x0, omega(k), N);
    err(k)  = norm(x_rich - x_exact,2);
end

% Plot the of the error...