clear all;
close all;
clc;

tol = 1e-12;

%testcase 1
A = [2 6 -2; 6 21 0; -2 0 16];
L = cholesky(A);
err = max(max(abs(L*L'-A)));

if (err < tol)
    fprintf('Testcase 1: Passed\n');
else
    fprintf(2,'Testcase 1: Failed\n');
end

%testcase 2
A = hilb(10);
L = cholesky(A);
err = max(max(abs(L*L'-A)));

if (err < tol)
    fprintf('Testcase 2: Passed\n');
else
    fprintf(2,'Testcase 2: Failed\n');
end

%testcase 3
A = rand(35);
A = A+A'+10*eye(35);
L = cholesky(A);
err = max(max(abs(L*L'-A)));

if (err < tol)
    fprintf('Testcase 3: Passed\n');
else
    fprintf(2,'Testcase 3: Failed\n');
end