clear all;
close all;
clc;

tol = 1e-12;

%testcase 1
A = 3*eye(4)+diag([1,1,1],-1)+diag([1,1,1],1);
L = cholesky_band(A,1);
err = max(max(abs(L*L'-A)));

if (err < tol)
    fprintf('Testcase 1: Passed\n');
else
    fprintf(2,'Testcase 1: Failed\n');
end

%testcase 2
A = 6*eye(7)+diag(2*ones(6,1),-1)+diag(2*ones(6,1),1)+...
    diag(ones(5,1),-2) + diag(ones(5,1),2);
L = cholesky_band(A,2);
err = max(max(abs(L*L'-A)));

if (err < tol)
    fprintf('Testcase 2: Passed\n');
else
    fprintf(2,'Testcase 2: Failed\n');
end

%testcase 3
n=50; 
A=rand(5,n); 
A=   diag(A(1,:))+diag(A(2,2:end),1)+diag(A(3,2:end),-1)...
    + diag(A(4,6:end),5)+diag(A(5,6:end),-5);
A = A+A'+n*eye(n);
L = cholesky_band(A,5);
err = max(max(abs(L*L'-A)));

if (err < tol)
    fprintf('Testcase 3: Passed\n');
else
    fprintf(2,'Testcase 3: Failed\n');
end