clear all;
close all;
clc;

%% generate data - runtime test

%allocate memory
N = [2.^(3:10), 2000, 5000];
time_cholesky = zeros(1,length(N));
time_choleskyBand = zeros(1,length(N));

i = 1;
for n = N
    A=rand(5,n); 
    A=diag(A(1,:))+diag(A(2,2:end),1)+diag(A(3,2:end),-1)...
    + diag(A(4,6:end),5)+diag(A(5,6:end),-5);
    A=A+A+sqrt(n-1)*eye(n);
   
   tic
   L = cholesky(A);
   time_cholesky(i) = toc;
   
   tic
   L = cholesky_band(A,4);
   time_choleskyBand(i) = toc;
    
   i = i+1;
end

%% plot data

loglog(N,time_cholesky,'r*-',N,time_choleskyBand,'b*-.')
set(gca,'FontSize',20)
title('Comparison of cholesky() and cholesky\_band().')
xlabel('Dimension n')
ylabel('Compuation Time in Seconds');
legend('cholesky','cholesky\_band')
