clear all;
close all;
clc;

tol = 1e-12;

%testcase 1
A = 3*eye(4)+diag([1,1,1],-1)+diag([1,1,1],1);
b = [1;1;-1;0];
x = thomasAlgo(A,b);
err = max(abs(x- A\b));

if (err < tol)
    fprintf('Testcase 1: Passed\n');
else
    fprintf(2,'Testcase 1: Failed\n');
end

%testcase 2
A = 6*eye(7)+diag(2*ones(6,1),-1)+diag(1*ones(6,1),1);
b = [1;0;-1;0;1;0;-1];
x = thomasAlgo(A,b);
err = max(abs(x- A\b));

if (err < tol)
    fprintf('Testcase 2: Passed\n');
else
    fprintf(2,'Testcase 2: Failed\n');
end

%testcase 3
A = 10*eye(20)+diag(3*ones(19,1),-1)+diag((-3)*ones(19,1),1);
b = ones(20,1);
x = thomasAlgo(A,b);
err = max(abs(x- A\b));

if (err < tol)
    fprintf('Testcase 3: Passed\n');
else
    fprintf(2,'Testcase 3: Failed\n');
end