clc,clear all, close all

% Add path of example
addpath('./Lshape');
% load geometry
load coordinates.dat; 
eval('load elements.dat;','elements3=[];');
eval('load neumann.dat;','neumann=[];');
load dirichlet.dat;

% refine mesh
for k=1:4
  [coordinates,elements,dirichlet,neumann] = ...
              refine(coordinates,elements,dirichlet,neumann);
end
% plot mesh 
figure(1)
subplot(1,2,1)
show(elements,[],coordinates,zeros(size(coordinates,1),1));
title('mesh')
view(2),axis equal

% compute indices of free nodes 
FreeNodes = setdiff(1:size(coordinates,1),unique(dirichlet));

% Initialize A,M, and b
A = sparse(size(coordinates,1),size(coordinates,1));
b = sparse(size(coordinates,1),1);

% Assembly stiffness matrix
for j = 1:size(elements,1)
  A(elements(j,:),elements(j,:)) = A(elements(j,:),elements(j,:)) ...
      + stima3(coordinates(elements(j,:),:));
end

% Assmbly right hand side
%*** TO DO!  *************************************************************


%*************************************************************************

% Computation of the solution
u(FreeNodes) = A(FreeNodes,FreeNodes) \ b(FreeNodes);

% graphic representation
figure(1)
subplot(1,2,2)
show(elements,[],coordinates,full(u));
view(2),shading interp,axis equal

