% uniforme Rotverfeinerung

function [coordinates,elements,dirichlet,neumann] = ...
		refine (coordinates,elements,dirichlet,neumann)

 % Initialisiere
 succ = [2,3,1]; 
 K = sparse(size(coordinates,1),size(coordinates,1));
 nodes = zeros(6,1);
 
 % Schleife ueber alle elements
 for j = 1:size(elements,1)
   nodes(1:3) = elements(j,1:3);
   %Schleife ueber Kanten
   for i = 1:3
     imin = min([elements(j,i),elements(j,succ(i))]); %Anfangsknoten
     imax = max([elements(j,i),elements(j,succ(i))]); %Endknoten

     % neuen Knoten erzeugen ?
     if (K(imin,imax)==0) 
        % erzeuge einen neuen Knoten
       nodes(3+i) = size(coordinates,1)+1 ;
       coordinates(size(coordinates,1)+1,:) = ...
              [(coordinates(imin,1)+coordinates(imax,1))/2, ...
               (coordinates(imin,2)+coordinates(imax,2))/2] ;
       K(imin,imax) = size(coordinates,1);

     % der gesuchte Knoten existiert schon
     else
       nodes(3+i) = K(imin,imax) ;
     end
   end

  % Update von elements
   elements(j,:) =  nodes([4,5,6]); 
   elements(size(elements,1)+1,:) =  nodes([1,4,6]);
   elements(size(elements,1)+1,:) =  nodes([4,2,5]); 
   elements(size(elements,1)+1,:) =  nodes([5,3,6]); 
 end

% Update von neumann
 for i = 1:size(neumann,1)
   nodes(1) = K(min([neumann(i,1),neumann(i,2)]),...
                 max([neumann(i,1),neumann(i,2)]));
   nodes(2) = neumann(i,2);  
   neumann(i,2) = nodes(1);
   neumann(size(neumann,1)+1,1:2) = nodes(1:2);
 end

% Update von dirichlet
 for i = 1:size(dirichlet,1)
   nodes(1) = K(min([dirichlet(i,1),dirichlet(i,2)]),...
                 max([dirichlet(i,1),dirichlet(i,2)]));
   nodes(2) = dirichlet(i,2);  
   dirichlet(i,2) = nodes(1);
   dirichlet(size(dirichlet,1)+1,1:2) = nodes(1:2);
 end

 end 
 