clear all, clc,close all
% muenster 200
% muenster2 50
% muenster3 160

%*** load picture
pic = imread('./pics/muenster4.jpg');
pic = rgb2gray(pic);
[m,n] = size(pic);

%*** plot picture
figure(1);
imshow(pic);
pic = pic(m:-1:1,:);

%*** initial coordinates, elements, boundary
coordinates = [1,1;n,1;1,m;n,m];
elements = [1,2,3;2,4,3];
boundary = [1,2;2,4;4,3;3,1];
[edge2nodes,element2edges,boundary2edges] ...
    = provideGeometricData(elements, boundary)
  
%*** refine mesh
for i =1:10
  fprintf('******** STEP  %d **********\n',i);
  %*** compute refinement indicator
  etaR = computeEtaR_pict(pic,elements,coordinates)
  %*** mark elements 
  %marked = markElements_absolute(etaR,120); 
  %marked = markElements_Doerfler(etaR,0.8); 
  marked = markElements_max(etaR,0.8) 

  %*** refine mesh
  [coordinates,elements,boundary]= refineRGB(coordinates,elements,boundary,marked);
end

%*** plot final mesh
figure
trisurf(elements, coordinates(:,1), coordinates(:,2), 0*coordinates(:,1),...
        'FaceColor', 'white')
axis equal
view(2)
