close all; 
clear all; 

% Number of realizations 
N = 10000; 
n = 100;

l_head = zeros(n,1);


for i = 1:n
    % Simulating N uniform distributed random variables
    U = rand(1,N); 

    % Computing the estimated value
    W = exp(-4 * U.^2);
    l_head(i) = sum(W .* (U > 3/4)) / sum(W); 
    fprintf('The estimated probability is %f1.4', mean(l_head)) 
end

hist(l_head);