N = 1;
n = 200;

weights = zeros(N,1);
square_extension = zeros(N,1);

% Possible moves in one step 
moves = [1 1; 1 0; 1 -1; 0 1; 0 -1; -1 1; -1 0; -1 -1]; 

for step_i = 1:N
    i = 1;

    while(i ~= n)
        path = [0 0];
        X = 0; Y = 0;
        weight = 1;
        
        % Empty latice 
        lattice = zeros(2*(n+1) + 1, 2*(n+1)+1);
        
        % Origin is marked
        lattice(n+2, n+2) = 1;
        
        for i = 1: 1: 2*n+3
            lattice(n+1, i) = 1;
            lattice(i, n+1) = 1;
        end
        
        for i = 1:n
            lattice_x = n + 2 + X; lattice_y = n + 2 + Y;
            
            % Check neighborhood 
            d1 = lattice(lattice_x + 1,lattice_y + 1);
            d2 = lattice(lattice_x + 1,lattice_y);
            d3 = lattice(lattice_x + 1,lattice_y - 1);
            d4 = lattice(lattice_x,lattice_y + 1);
            d5 = lattice(lattice_x,lattice_y - 1);
            d6 = lattice(lattice_x - 1,lattice_y + 1);
            d7 = lattice(lattice_x - 1,lattice_y);
            d8 = lattice(lattice_x - 1,lattice_y - 1);
            
            neighbors = [1 1 1 1 1 1 1 1] - ...
                        [d1 d2 d3 d4 d5 d6 d7 d8];
	
            % Rejection if there are no neighbors
            if sum(neighbors) == 0
                i = 1;
                break;
            end
            
            % Update weight
            weight = weight * sum(neighbors);
            direction = ...
                min(find(rand<(cumsum(neighbors)/sum(neighbors))));
            
            % Move
            X = X + moves(direction,1);
            Y = Y + moves(direction,2);
            lattice_x = n + 2 + X; lattice_y = n + 2 + Y;
            lattice(lattice_x,lattice_y) = 1;
            
            % Update path
            path_addition = [X Y];
            path = [path; path_addition];
        end
    end
	weights(step_i) = weight;
	square_extension(step_i) = X^2 + Y^2;
    
    clf; hold on;
    axis([min(path(:,1)) max(path(:,1)) min(path(:,2)) max(path(:,2))]);
	for j = 1:n
        line([path(j,1), path(j+1,1)], [path(j,2), path(j+1,2)]);
	end
end
mean_square_extension = mean(weights .*square_extension) / mean(weights);