clear all;
close all;

N = 10000;
X = zeros(1,11);
x10 = zeros(1,N);

% Simulation of 10000 realizations of {X_n} from n=0,...,10
for i = 1:N
    X(1) = (rand <= 0.5);
    for j = 2:11
        if(X(j-1)==0)
            X(j) = 1;
        else
            if(X(j-1)==4)
                X(j) = 3;
            else
                X(j) = X(j-1) + 2*(rand <= 0.5) - 1;
            end
        end
    end
    x10(i) = X(11);
end


% Computing the exact distribution 

% Initial distribution 
alpha = [0.5 0.5 0 0 0];

% Transition matrix
P = [0 1 0 0 0;
     0.5 0 0.5 0 0;
     0 0.5 0 0.5 0;
     0 0 0.5 0 0.5;
     0 0 0 1 0];
 p10 = alpha * P^10;

for i = 0:4
    p = sum((x10 == i)) / N;
    fprintf('The estimated value for P(X_10 = %d) is %1.4f \n', [i p]);
    fprintf('The exact value for P(X_10 = %d) is %1.4f \n', [i p10(i+1)]);
end



