Stepnumber = 100000;
Noisestep = 50;
dt = 10^(-15);


Temp = 500; %Kelvin
Ekin = 1.38065 * 10^(-23)*Temp; %=2*0.5*kb T

r0 = [1.5 1.5]';
posstart = r0*10^(-10);


m = 26.98*1.66*10^(-27);
v = sqrt(2*Ekin/m);
angle = rand*360; %zufällige Richtung
vstart = [v*cos(angle/180*pi), v*sin(angle/180*pi)]';


[posout, vout, Etota, Ekina] = Verlet_allinclusive(posstart, vstart, Noisestep, dt);

display(size(posout))
display(size(vout))

for i = 1:Stepnumber/Noisestep

    %Reskalierung und kleine zufällige Rotation
    v_noise = vout(:,end)/norm(vout(:,end))*sqrt(2*Ekin/m);
    a = pi/4*(rand*2.-1.);
    v_noise = mtimes([[cos(a) sin(a)]; [-sin(a) cos(a)]], v_noise); 
    
    [posout1, vout1, Etota1, Ekina1] = Verlet_allinclusive(posout(:,end), v_noise, Noisestep, dt);
    posout = cat(2,posout, posout1);
    vout = cat(2,vout, vout1);
    Etota = cat(2,Etota, Etota1);
    Ekina = cat(2,Ekina,Ekina1 );
end
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Zum Zeichnen der Trajektorie
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   plot(posout(1,:)*10^10, posout(2,:)*10^10)
   xlabel('x')
   ylabel('y')
% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Wie variiert die Gesamtenergie mit der Zeit?
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot(Etota/(1.6022*10^(-19)))
% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Zur besseren Vorstellung: 3D Plot auf dem Potential
% 
% plot3(Positionsa(1,:)*10^10, Positionsa(2,:)*10^10, (Etota(1,:)-Ekina(1,:))/(1.6022*10^(-19)) )
% 
% hold on
% 
% x = -0.5:0.2:3.5;
% y=-0.5:0.2:3.5;
% POT0=1.0
% A=3.0
% 
% [X,Y]=meshgrid(x,y);
% ARGX = 2.*pi*X./A
% ARGY = 2.*pi*Y./A
% 
% Z = 0.25*POT0*(2.+cos(ARGX)+cos(ARGY));
% 
% mesh(X,Y,Z-0.1,'edgecolor', 'black') % zeichnet die Punkte (x,y,z) und verbindet sie
% %surf(X,Y,Z,Z)
% xlabel('x')
% ylabel('y')
% zlabel('Potential')
% axis vis3d
% 
% hold off
% 
% 
% 



































