function [Positionsa,vArray, Etota, Ekina] = Verlet_allinclusive(r0, v0, stepnumber, dt)

m = 26.98*1.66*10^(-27);
[Positionsa,vArray, Etota, Ekina] = Initialize(r0,v0, stepnumber, dt);

for i=1:stepnumber
    if i>2
        r1 = Positionsa(:,i-1);
        r0 = Positionsa(:,i-2);
        posout = 2*r1 -r0 + dt^2*Force(r1)/m;
        v = (posout-r0)/(2*dt);
        Ekin= 0.5*m*norm(v)^2;
        Epot = Potential(Positionsa(:,i-1));
        Positionsa(:,i) = posout;
        vArray(:,i-1) = v;
        Ekina(1,i-1) = Ekin;
        Etota(1,i-1) = Epot+Ekin;
        
    end
end
Positionsa = Positionsa(:,1:end-1);
end


function [posArray,vArray, Etota, Ekina] = Initialize(posstart,vstart, Stepnumber, dt)
m = 26.98*1.66*10^(-27);
Ekin=0.5*m*norm(vstart)^2;
pos1 = posstart + dt*vstart + 0.5*Force(posstart)/m*dt^2;
posArray=zeros(2, Stepnumber);
vArray = zeros(2,Stepnumber-1);
Etota = zeros(1, Stepnumber-1);
Ekina = zeros(1, Stepnumber-1);
posArray(:,1) = posstart;
posArray(:,2) = pos1;
vArray(:,1) = vstart;
vArray(:,2) = vstart;
Etota(1) = Potential(posstart)+Ekin;
Ekina(1) = Ekin;
Etota(2) = Potential(posstart)+Ekin;
Ekina(2) = Ekin;
end

function out = Potential(x)
V0 = 1.6022*10^(-19);
a = 3 * 10^(-10);
out = 0.25 * V0 * ( 2 + cos(2*pi/a*x(1)) + cos(2*pi/a*x(2)));
end



function out = Force(x)
V0 = 1.6022*10^(-19);
a = 3*10^(-10);
out = [0.25 * V0 * 2*pi/a*sin(2*pi/a*x(1)), 0.25 * V0 * 2*pi/a*sin(2*pi/a*x(2))]';
end
