N = 1000;
A = [1,0.8;0.8,1];     %Kovarianzmatrix

u = zeros(N,1);
v = zeros(N,1);
for i = 1:N                        %Gaus-Copula
    z = randn(2,1);
    x = transpose(chol(A))*z;      % hier ist Vorsicht geboten, da Matlab die Cholesky-Zerlegung Transponiert.
    u(i) = normcdf(x(1));
    v(i) = normcdf(x(2));
end

X_1 = exp(-0.0277+sqrt(0.0149)*norminv(u,0,1));
X_2 = exp(-0.1099+sqrt(0.0089)*norminv(v,0,1));

plot(X_1,X_2,'.')




